package com.bcxin.ars.timer.gradeclass;

import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sb.GradeClassService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.timer.gradePerson.AutoGradePersonCensorStatus;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * 自动更新班级的审批状态
 */
@Service
public class AutoGradeClass {
    /***
     * 日志
     */
    private static  final Logger logger = LoggerFactory.getLogger(AutoGradeClass.class);
    @Value("${timeFlag}")
    private String timeFlag = "";
    @Autowired
    private JobRunLogService jobRunLogService;
    @Autowired
    private GradeClassService gradeClassService;
    @Autowired
    private ConfigUtils configUtils;
    public void run() {
        if (configUtils.isIntranet() && timeFlag.equals(Constants.TIMEFLAG_VALUE)) {
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(true);
            log.setUpdateBy("jobSystem");
            //开始时间
            long startTime = System.currentTimeMillis();
            try {
                String hour =  configUtils.getValueByKey(Constants.GRADE_HOUR_AUTOAPPROVAL);
                //如果为空设置默认值
                if(StringUtil.isEmpty(hour)){
                    hour = Constants.GRADE_HOUR_AUTOAPPROVAL_DEFAULT;
                }
                gradeClassService.autoUpdateApprovalState(hour);
            }catch (Exception e){
                logger.error(e.getMessage(),e);
                log.setExceptionMsg(e.toString());
            }
            //日志信息
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(AutoGradePersonCensorStatus.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength((endTime - startTime) + "ms");
            jobRunLogService.insert(log);

        }
    }


}
