package com.bcxin.ars.timer;


import com.bcxin.ars.dao.sb.*;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dao.sys.ApprovalLogDao;
import com.bcxin.ars.model.sb.*;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.NXIntegratedInterfaceUtil;
import com.bcxin.ars.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


/**
 * @author
 * @date 2020/12/07 0007 14:53
 */
@Service
public class AutoPushToIntegratedService {
    private static Logger logger = LoggerFactory.getLogger(AutoPushToIntegratedService.class);

    @Autowired
    SponsorlicenseDao sponsorlicenseDao;

    @Autowired
    TraincompanyapplyDao traincompanyapplyDao;

    @Autowired
    SubsidiaryDao subsidiaryDao;
    @Autowired
    PersoncertificateDao personcertificateDao;
    @Autowired
    CrosscompanyDao crosscompanyDao;
    @Autowired
    ConfesscompanyDao confesscompanyDao;
    @Autowired
    LegalchangeDao legalchangeDao;
    @Autowired
    ApprovalDAO approvalDAO;
    @Autowired
    ApprovalLogDao approvalLogDao;

    @Autowired
    NXIntegratedInterfaceUtil nxIntegratedInterfaceUtil;
    @Autowired
    private ConfigUtils configUtils;


    private boolean lock = false;

    public void run() {
        if (lock) {
            return;
        }
        lock = true;

        try {

            if (Constants.NINGXIA.equals(configUtils.getCurrentNative()) && configUtils.isIntranet()) {
                try {


                    List<Sponsorlicense> sponsorlicenses = sponsorlicenseDao.findUnIntegrated();
                    nxIntegratedInterfaceUtil.pushAllSponsorlicense(sponsorlicenses, "001");
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }


           /* List<ApprovalDTO> approvalDTOList = approvalDAO.findUnIntegrated();
            nxIntegratedInterfaceUtil.pushApproval(approvalDTOList);

            List<ApprovalLogDto> approvalLogDtos = approvalLogDao.findUnIntegrated();
            nxIntegratedInterfaceUtil.pushApprovalLog(approvalDTOList);*/
                try {
                    List<Traincompanyapply> traincompanyapplies = traincompanyapplyDao.findUnIntegrated();
                    nxIntegratedInterfaceUtil.pushAllTraincompanyapply(traincompanyapplies, "002");
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
                try {
                    List<Subsidiary> subsidiaries = subsidiaryDao.findUnIntegrated();
                    nxIntegratedInterfaceUtil.pushAllSubsidiary(subsidiaries, "003");
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
                try {
                    List<Personcertificate> personcertificates = personcertificateDao.findUnIntegrated();
                    nxIntegratedInterfaceUtil.pushAllPersoncertificate(personcertificates, "004");
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
                try {
                    List<Crosscompany> crosscompanies = crosscompanyDao.findUnIntegrated();
                    nxIntegratedInterfaceUtil.pushAllCrosscompany(crosscompanies, "005");
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
                try {
                    List<Confesscompany> confesscompanies = confesscompanyDao.findUnIntegrated();
                    nxIntegratedInterfaceUtil.pushAllConfesscompany(confesscompanies, "006");
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
                try {
                    List<Legalchange> legalchanges = legalchangeDao.findUnIntegrated();
                    nxIntegratedInterfaceUtil.pushAllLegalchange(legalchanges, "007");
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }

            }


        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        } finally {
            lock = false;
        }

    }
}