package com.bcxin.ars;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.ars.dao.FilerecordDao;
import com.bcxin.ars.dao.FilerecordOutDao;
import com.bcxin.ars.dao.FilerecordStatusDao;
import com.bcxin.ars.dao.SyncFailLogDao;
import com.bcxin.ars.dao.sys.SyncDataDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.ConfigSyncData;
import com.bcxin.ars.service.*;
import com.bcxin.ars.service.certificate.SecurityCertificateService;
import com.bcxin.ars.service.exam.TrainExamInfoService;
import com.bcxin.ars.service.exam.TrainExamPersonService;
import com.bcxin.ars.service.msg.*;
import com.bcxin.ars.service.sb.*;
import com.bcxin.ars.service.sys.ApprovalService;
import com.bcxin.ars.service.sys.SyncDataService;
import com.bcxin.ars.service.task.*;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.*;
import com.bcxin.ars.webservice.ClientUtil;
import com.google.common.io.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.crypto.BadPaddingException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.*;

import static com.bcxin.ars.util.DateUtil.DATATYPE_MINUTE;

/**
 * 同步公安内外网数据
 * Created by subh on 2017/6/3.
 */
@Service
public class Data2SynchronizationService {
    private Logger logger = LoggerFactory.getLogger(Data2SynchronizationService.class);

    @Autowired
    private ConfigUtils configUtils;
    /**
     * 任务信息
     */
    @Autowired
    private TaskService taskService;
    /***
     * 人员
     */
    @Autowired
    private SecurityPersonService securityPersonService;

    @Autowired
    private SecurityCertificateService securityCertificateService;
    @Autowired
    private SyncDataDao syncDataDao;
    @Autowired
    private SyncFailLogDao syncFailLogDao;

    @Autowired
    private ConfigService configService;
    @Autowired
    private SecurityCompanyPersonService securityCompanyPersonService;
    /***
     * 用户
     */
    @Autowired
    private UserService userService;

    /**
     * 公安机构
     */
    @Autowired
    private PoliceService policeService;

    /**
     * 公安角色
     */
    @Autowired
    private PoliceRoleService policeRoleService;

    /***
     * 角色
     */
    @Autowired
    private RoleService roleService;
    /**
     * 公司
     */
    @Autowired
    private SecurityCompanyService securityCompanyService;

    /**
     * 公司班次
     */
    @Autowired
    private SecurityCompanyScheduleService securityCompanyScheduleService;
    /**
     * 组织架构
     */
    @Autowired
    private OrganizationService organizationService;
    /**
     * 审批信息
     */
    @Autowired
    private ApprovalService approvalService;
    /**
     * 自行招用
     */
    @Autowired
    private ConfesscompanyService confesscompanyService;
    /**
     * 跨区
     */
    @Autowired
    private CrosscompanyService crosscompanyService;
    /***
     * 法人
     */
    @Autowired
    private LegalchangeService legalchangeService;

    @Autowired
    private LegalchangeworkexperienceService legalchangeworkexperienceService;
    /***
     * 个人主要简历
     */
    @Autowired
    private WorkexperienceService workexperienceService;
    /***
     * 年度报告
     */
    @Autowired
//    private YearreportService yearreportService;
    private YearreportdataService yearreportDataService;

    @Autowired
    private SecurityCompanyInsuranceService securityCompanyInsuranceService;

    @Autowired
    private YearreportdataManagerService yearreportdataManagerService;

    @Autowired
    private YearReportInsuranceService yearReportInsuranceService;

    @Autowired
    private YearReportInvestorService yearReportInvestorService;

    /***
     * 保安员证
     */
    @Autowired
    private PersoncertificateService personcertificateService;
    /***
     * 家庭成员
     */
    @Autowired
    private FamilyService familyService;
    /***
     * 工作经历
     */
    @Autowired
    private PersonworkexperienceService personworkexperienceService;
    /***
     * 保安服务公司
     */
    @Autowired
    private SponsorlicenseService sponsorlicenseService;
    /***
     * 股东出资额及所占比例
     */
    @Autowired
    private ShareholderService shareholderService;
    /***
     * 子公司
     */
    @Autowired
    private SubsidiaryService subsidiaryService;
    /***
     * 子公司备案
     */
    @Autowired
    private SubsidiarypersonService subsidiarypersonService;
    /***
     * 培训单位
     */
    @Autowired
    private TraincompanyapplyService traincompanyapplyService;

    @Autowired
    private UrgentTeamService urgentTeamService;

    @Autowired
    private TeamPersonService teamPersonService;

    @Autowired
    private TaskPersonService taskPersonService;

    @Autowired
    private TaskPersonScheduleService taskPersonScheduleService;

    @Autowired
    private TaskPersonScheduleDetailService taskPersonScheduleDetailService;

    @Autowired
    private TaskScheduleService taskScheduleService;
    @Autowired
    private TaskFeedbackService taskFeedbackService;
    @Autowired
    private DatasyncService datasyncService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderPersonService orderPersonService;
    @Autowired
    private OrderTransactionService orderTransactionService;
    @Autowired
    private SbSubsidiaryBaseService sbSubsidiaryBaseService;
    @Autowired
    private SbSubsidiaryManagerService sbSubsidiaryManagerService;
    @Autowired
    private SbBusinessManagementService sbBusinessManagementService;
    @Autowired
    private SbBusinessOutsideManagementService sbBusinessOutsideManagementService;
    @Autowired
    private SbRewardService sbRewardService;
    @Autowired
    private SbPunishService sbPunishService;
    @Autowired
    private SecurityGoodThingService securityGoodThingService;
    @Autowired
    private VehicleService vehicleService;
    @Autowired
    private VehicleLogService vehicleLogService;
    @Autowired
    private FirearmsService firearmsService;
    @Autowired
    private CyFirearmsLogService cyFirearmsLogService;
    @Autowired
    private SafetyService safetyService;
    @Autowired
    private InvestorService investorService;
    @Autowired
    private ManagementInfoService managementInfoService;
    @Autowired
    private CyServerhtService cyServerhtService;
    @Autowired
    private FilerecordDao filerecordDao;

    @Autowired
    private FilerecordOutDao filerecordOutDao;

    @Autowired
    private FilerecordStatusDao filerecordStatusDao;

    @Autowired
    private ClientUtil clientUtil;

    @Autowired
    private ArmtrainorgService armtrainorgService;

    @Autowired
    private ArmorgteachService armorgteachService;

    @Autowired
    private ArmorgchargeService armorgchargeService;

    @Autowired
    private ArmtrainchargeService armtrainchargeService;

    @Autowired
    private ConfesscompanyundoService confesscompanyundoService;
    @Autowired
    private NewsnoticeCompanyService newsnoticeCompanyService;
    @Autowired
    private NewsnoticePoliceService newsnoticePoliceService;

    @Autowired
    private NewsCompanyRelationshipService newsCompanyRelationshipService;

    @Autowired
    private NewsnoticeRecipientService newsnoticeRecipientService;

    @Autowired
    private SysAttachmentService sysAttachmentService;

    @Autowired
    private SyncDataService syncDataService;

    @Autowired
    private SbSponsorlicenseManagerService sbSponsorlicenseManagerService;

    @Autowired
    private SbSponsorlicenseVmanagerService sbSponsorlicenseVmanagerService;

    @Autowired
    private TrainExamInfoService trainExamInfoService;

    @Autowired
    private TrainExamPersonService trainExamPersonService;


    @Value("${ftp-folder}")
    private String ftpFolder;
    @Value("${ftp-temp-folder}")
    private String tempftpFolder;
    @Value("${timeFlag}")
    private String timeFlag = "";

    /**
     * 获取两个日期之间的日期
     *
     * @param start 开始日期
     * @param end   结束日期
     * @return 日期集合
     */
    public List<Date> getBetweenDates(Date start, Date end) {
        List<Date> result = new ArrayList<Date>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        tempStart.add(Calendar.DAY_OF_YEAR, 1);

        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        while (tempStart.before(tempEnd)) {
            result.add(tempStart.getTime());
            tempStart.add(Calendar.DAY_OF_YEAR, 1);
        }
        return result;
    }

    public void run() {
        //获取配置是否要同步
        Config datasynchronizationconfig = configUtils.getConfigByKey(Constants.DATASYNCHRONIZATION);
        //不同步
        if (datasynchronizationconfig != null && Constants.DATASYNCHRONIZATION_YES.equals(datasynchronizationconfig.getValue()) && Constants.TIMEFLAG_VALUE.equals(timeFlag)) {
            Config config = configUtils.getConfigByKey(Constants.POLICE);
            //公安端
            String nowStr = DateUtil.getCurrentDate();
            if (config != null && Constants.POLICE_IN.equals(config.getValue())) {
                /***
                 * 最后同步日期
                 */
                Config lastDateConfig = configUtils.getConfigByKey(Constants.LASTDATE);
                if (lastDateConfig != null) {
                    String lastDate = lastDateConfig.getValue();
                    List<Date> dates = getBetweenDates(DateUtil.convertStringToDate(lastDate), DateUtil.convertStringToDate(nowStr));
                    //加入当前日期
                    dates.add(DateUtil.convertStringToDate(nowStr));

                    for (Date d : dates) {
                        //任务信息
                        String filePath = ftpFolder + DateUtil.convertDateToString(d, DateUtil.FORMAT2);
                        // 获取文件夹
                        File f = new File(filePath);
                        if (!f.exists()) {
                            break;
                        }
                        //读取是否有错误
                        boolean errorFlag = false;
                        String[] filenames = {"police", "policeRole", "user", "company", "organization", "role", "person",
                                "securityCompanySchedule", "task", "taskFeedback", "crosscompany",
                                "confesscompany", "traincompanyapply", "workexperience", "legalchange", "legalchangeworkexperience",
                                "yearreport", "securityCompanyInsurance", "yearreportdataManager", "yearReportInsurance", "yearReportInvestor", "armtrainorg", "armorgteach", "armorgcharge",
                                "armtraincharge", "personcertificate", "family", "personworkexperience",
                                "subsidiary", "subsidiaryperson", "sponsorlicense", "sbsponsorlicenseManager", "sbsponsorlicenseVManager", "sponsorlicense", "confesscompanyundo", "securitycertificate",
                                "shareholder", "approval", "datasync", "order", "orderPerson",
                                "orderTransaction", "sbSubsidiaryBase", "sbSubsidiaryManager", "sbBusinessManagement",
                                "sbBusinessOutsideManagement", "sbReward", "sbPunish", "securityGoodThing",
                                "vehicle", "vehicleLog", "firearms", "cyFirearmsLog", "safety", "investor", "managementInfo",
                                "cyServerht", "newsnoticePolice", "newsnoticeCompany", "newsCompanyRelationship", "sysAttachment", "newsnoticeRecipient",
                                "trainExamInfo", "trainExamPerson"
                        };

                        Map<String, String> fileNameMap = new LinkedHashMap<String, String>();

                        /**** 文件名filename: personcertificate_20180730150010.data  ****/


                            //每一条都读
                            File fa[] = f.listFiles();   // 文件列表
                            for (int i = 0; i < fa.length; i++) {
                                File fs2 = fa[i];
                                String[] splitFiles = fs2.getName().replace(".data", "").split("_");
                                if (splitFiles.length == 2) {
                                    List<String> list=Arrays.asList(filenames);
                              if (list.contains(splitFiles[0])){

                               String  filename=splitFiles[0];

                                        String createTime = splitFiles[1];
                                        if (StringUtil.isEmpty(createTime)) {
                                            continue;
                                        }
                                        File fs = new File(filePath + "/" + filename + "_" + createTime + ".data");
                                        /** 文件存在且类型不为文件夹 by llc 2018-08-06  **/
                                        if (fs.exists() && fs.isFile()) {
                                            try {
                                                logger.info(filePath + "/" + filename + "_" + createTime + ".data");
                                                BufferedReader br = new BufferedReader(new FileReader(fs));
                                                StringBuffer content = new StringBuffer();
                                                // 获取文件内容
                                                String lineTxt = null;
                                                while ((lineTxt = br.readLine()) != null) {// 使用readLine方法，一次读一行
                                                    content.append(lineTxt);
                                                }
                                                br.close();
                                                String jsonStr = new String(CipherDESUtil.decrypt(Encodes.decodeHex(content.toString()), Constants.APPROVAL_KEY));
                                                // 机构信息ID保持内外网一致
                                                if (fs.getName().equals("approval" + "_" + createTime + ".data")) {
                                                    Filerecord dbfilerecord = isFilerecord(fs.getAbsolutePath());
                                                    if (dbfilerecord == null) {
                                                        List<Approval> approvalList = JSONArray.parseArray(jsonStr, Approval.class);
                                                        if (approvalList != null && approvalList.size() > 0) {
                                                            for (Approval approval : approvalList) {
                                                                try {
                                                                    approvalService.saveOrUpdateForDS(approval);
                                                                } catch (Exception e) {
                                                                    logger.error(e.getMessage(), e);
                                                                    e.printStackTrace();
                                                                }
                                                            }
                                                            //将已读过的文件名记录
                                                            saveFielrecord(fs.getAbsolutePath(), fs.getName(), approvalList.size());
                                                        }
                                                    }
                                                } else {
                                                    syncDataService.syncDataByJava(jsonStr, fs);
                                                }
                                            } catch (BadPaddingException badPaddingException) {
                                                logger.error("读取(" + fs.getName() + ")文件内容出错,非该区域文件");
                                                logger.error(fs.getName());
                                                badPaddingException.printStackTrace();
                                                logger.error(badPaddingException.getMessage());
                                                errorFlag = true;
                                                continue;
                                            } catch (Exception e) {
                                                logger.error("读取(" + fs.getName() + ")文件内容出错");
                                                logger.error(fs.getName());
                                                e.printStackTrace();
                                                logger.error(e.getMessage(), e);
                                                errorFlag = true;
                                                continue;
                                            }
                                        } else {
                                            System.out.println("找不到指定的（" + fs.getName() + "）文件");
                                        }
                                    }
                                    //如果文件没有读取错误
                                    if (!errorFlag) {
                                        Config updateConfig = new Config();
                                        updateConfig.setKey(Constants.LASTDATE);
                                        updateConfig.setValue(DateUtil.convertDateToString(d, DateUtil.FORMAT2));
                                        configUtils.updateForKey(updateConfig);
                                    }
                                }

                        }
                    }
                }
            } else {
                //生成文件，从外网生成需要同步的数据

                DataSynchronizationSearchDto searchDto = new DataSynchronizationSearchDto();
                searchDto.setPaging(false);
                Config startDateConfig = configService.findByKey(Constants.SYNC_READ_STARTTIME);
                Config offsetConfig = configService.findByKey(Constants.OFFSET_TIME);


                try {
                    searchDto.setStartDate(DateUtil.convertDateToString(DateUtil.dateAdd2(DATATYPE_MINUTE,DateUtil.convertStringToDate(startDateConfig.getValue()),offsetConfig.getValue()==null?0:Integer.parseInt(offsetConfig.getValue())*(-1)),"yyyy-MM-dd HH:mm:ss"));
                    searchDto.setEndDate(DateUtil.getTomorrow());
                    //searchDto.setEndDate(DateUtil.convertDateToString(DateUtil.dateAdd2(DATATYPE_MINUTE,DateUtil.convertStringToDate(startDateConfig.getValue()),offsetConfig.getValue()==null?0:Integer.parseInt(offsetConfig.getValue())),"yyyy-MM-dd HH:mm:ss"));
                } catch (Exception e) {
                    e.printStackTrace();
                }

                //申报
                List<Approval> approvalList = approvalService.searchForDataSynchronization(searchDto);

                if (approvalList != null && approvalList.size() > 0) {
                    try {
                        String approvalListStr = JSONArray.toJSONString(approvalList);
                        //	System.out.println(approvalListStr);
                        String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(approvalListStr.getBytes(), Constants.APPROVAL_KEY));
                        writeTxtFile(content, "approval");
                    } catch (Exception e) {
                        logger.error(e.getMessage(), e);
                    }
                }
                this.createDataSyncFile(DateUtil.getTomorrow(), DateUtil.getYesterday());

                //全部生成完，复制到正式目录 ftpFolder
                try {
                    copyDir(tempftpFolder + nowStr, ftpFolder + nowStr);
                    startDateConfig.setValue(DateUtil.convertDateToString(new Date(), "yyyy-MM-dd HH:mm:ss"));
                    configService.update(startDateConfig);
                } catch (IOException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
    }

    private void createDataSyncFile(String syncStartDate, String syncEndDate) {

        long startTime = System.currentTimeMillis();

        /*** 如果界面传入的同步开始日期为空，则同步时间提前一天 ***/
        if (StringUtil.isEmpty(syncStartDate)) {
            syncStartDate = DateUtil.getYesterday();
        }

        /*** 获取 ConfigSyncDataList ***/
        List<ConfigSyncData> configList = syncDataDao.getConfigSyncDataList();

        List<String> filePathList = new ArrayList<>();

        /*** 如果是公安外网需要取邮件发送信息 ***/
        Config police = configService.findByKey("police");
        Config syncDataNotifier = new Config();
        Config currentEnvi = new Config();
        if (police != null && police.getValue().equals("0")) {
            syncDataNotifier = configService.findByKey("syncDataNotifier");
            currentEnvi = configService.findByKey("current_native_name");
        }
        EmailUtils email = new EmailUtils();
        String currentEnviName = currentEnvi.getValue() == null ? "" : currentEnvi.getValue();
        for (ConfigSyncData config : configList) {
            Map<String, Object> param = new HashMap<String, Object>();
            /*** 查询数据 ***/
            param.put("sql", "SELECT * FROM `" + config.getTableName() + "` limit 100");
            List<Map<String, Object>> dataList = syncDataDao.executeSelectSql(param);

            if (dataList != null && dataList.size() > 0) {
                try {
                    String dataJsonStr = JSONArray.toJSONString(dataList, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat);
                    String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(dataJsonStr.getBytes(), Constants.APPROVAL_KEY));
                    writeTxtFile(content, config.getFileName());
                } catch (Exception e) {
                    e.printStackTrace();
                    /***  邮件通知 ***/
                    if (police != null && police.getValue().equals("0")) {
                        if (syncDataNotifier != null && syncDataNotifier.getValue() != null) {
                            email.sendEmail("百保盾外网生成数据文件出错",
                                    "同步环境:【" + currentEnviName + "外网" + "】\n" +
                                            "文件名:【" + config.getFileName() + ".data" + "】\n" +
                                            "异常信息:【" + e.getMessage().toString() + "】",
                                    syncDataNotifier.getValue());
                        }
                    }
                }
            }
        }

        long endTime = System.currentTimeMillis();
        System.out.println("当前程序耗时：" + (endTime - startTime) + "ms");
    }

    private void writeTxtFile(String readStr, String type) {
//    	System.out.println(type);
        try {
            String basePath = tempftpFolder;    //路径
            String filePath = basePath + DateUtil.getCurrentDate() + File.separator;//保存路径

            String fileName = type;
            String fileType = ".data";
            File file = new File(filePath);
            if (!file.exists()) {
                file.mkdirs();
                System.out.println("文件夹已创建");
            }
            String fullFilePath = filePath + fileName + "_" + DateUtil.getCurrentDateTime(DateUtil.FORMAT8) + fileType;

            saveFielrecordOut(fullFilePath, fileName + "_" + DateUtil.getCurrentDateTime(DateUtil.FORMAT8) + fileType);
            //文件处理：写入文件
            File newFile = new File(fullFilePath);
            Files.write(readStr.getBytes(), newFile);
        } catch (Exception e) {
            //System.out.println("导出失败！");
            logger.error(e.getMessage(), e);
        }
    }

    public static void copyDir(String oldPath, String newPath) throws IOException {
        File file = new File(oldPath);
        String[] filePath = file.list();

        if (!(new File(newPath)).exists()) {
            (new File(newPath)).mkdir();
        }

        if (filePath == null) {
            return;
        }
        for (int i = 0; i < filePath.length; i++) {
            if ((new File(oldPath + File.separator + filePath[i])).isDirectory()) {
                copyDir(oldPath + File.separator + filePath[i], newPath + File.separator + filePath[i]);
            }

            if (new File(oldPath + File.separator + filePath[i]).isFile()) {
                File from = new File(oldPath + File.separator + filePath[i]);
                File to = new File(newPath + File.separator + filePath[i]);
                if (!to.exists()) {
                    Files.copy(from, to);
                }
            }
        }
    }

    /*
    判断是否已经读过
     */
    public Filerecord isFilerecord(String filename) {
        Filerecord dbfilerecord = filerecordDao.findByFilepath(filename);
        if (dbfilerecord == null) {
            System.out.println("开始读取文件：" + filename);
        }
        return dbfilerecord;
    }

    public void saveFielrecord(String filepath, String filename, Integer recordsize) {
        //将已读过的文件名记录
        Filerecord filerecord = new Filerecord();
        filerecord.setFilepath(filepath);
        filerecord.setFilename(filename);
        filerecord.setCreateTime(new Date());
        filerecord.setSynchtype(filename.substring(0, filename.indexOf("_")));
        filerecord.setUpdateTime(filerecord.getCreateTime());
        filerecord.setRecordsize(recordsize);
        filerecordDao.save(filerecord);
        System.out.println("读取文件完成：" + filename);
    }

    public void saveFielrecordOut(String filepath, String filename) {
        //将已写过的文件名记录
        FilerecordOut filerecordOut = new FilerecordOut();
        filerecordOut.setFilepath(filepath);
        filerecordOut.setFilename(filename);
        filerecordOut.setSynchtype(filename.substring(0, filename.indexOf("_")));
        filerecordOut.setCreateTime(new Date());
        filerecordOut.setUpdateTime(filerecordOut.getCreateTime());
        filerecordOutDao.save(filerecordOut);

        System.out.println("写入文件完成：" + filename);
    }
}
