/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.task;

import com.bcxin.ars.dao.task.ComTaskDao;
import com.bcxin.ars.dao.task.ComTaskDaoAop;
import com.bcxin.ars.dao.task.ComTaskPerDao;
import com.bcxin.ars.dao.task.ComTempTaskDao;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ComTaskStatusService {
    private Logger logger = LoggerFactory.getLogger(ComTaskStatusService.class);
    @Autowired
    ComTaskDao comTaskDao;
    @Autowired
    ComTempTaskDao comTempTaskDao;
    @Autowired
    ComTaskDaoAop comTaskDaoAop;
    @Autowired
    private ComTaskPerDao comTaskPerDao;
    @Autowired
    private JobRunLogService jobRunLogService;
    @Value(value="${timeFlag}")
    private String timeFlag = "";

    public synchronized void autoUpdateTaskStatus() {
        if (this.timeFlag.equals("true")) {
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(Boolean.valueOf(true));
            log.setUpdateBy("jobSystem");
            long startTime = System.currentTimeMillis();
            try {
                this.comTaskDao.updateStartTaskStatus();
                this.comTempTaskDao.updateStartTaskStatus();
                List taskList = this.comTaskDao.findEndTaskList();
                if (taskList.size() > 0) {
                    this.comTaskDaoAop.endTaskStatus(taskList);
                    this.comTaskDao.removeRelationTaskList(taskList);
                    this.comTaskPerDao.deleteByTaskList(taskList);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                log.setExceptionMsg(e.toString());
            }
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(ComTaskStatusService.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength(endTime - startTime + "ms");
            this.jobRunLogService.insert(log);
        }
    }
}

