/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.report;

import cn.hutool.core.thread.ThreadUtil;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.report.ReportCompanyService;
import com.bcxin.ars.service.report.ReportPersonService;
import com.bcxin.ars.service.report.ReportPersoncertificateService;
import com.bcxin.ars.service.report.ReportProblemPersonService;
import com.bcxin.ars.service.report.ReportTaskService;
import com.bcxin.ars.service.report.ReportTrainService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class IndexReportService {
    Logger logger = LoggerFactory.getLogger(IndexReportService.class);
    @Autowired
    private ReportProblemPersonService reportProblemPersonService;
    @Autowired
    private ReportPersonService reportPersonService;
    @Autowired
    private ReportCompanyService reportCompanyService;
    @Autowired
    private ReportPersoncertificateService reportPersoncertificateService;
    @Autowired
    private ReportTaskService reportTaskService;
    @Autowired
    private ReportTrainService reportTrainService;
    @Autowired
    private JobRunLogService jobRunLogService;
    @Autowired
    private ConfigUtils configUtils;
    @Value(value="${timeFlag}")
    private String timeFlag = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateReport() {
        if ("11".equals(this.configUtils.getCurrentNative()) && this.timeFlag.equals("true")) {
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(Boolean.valueOf(true));
            log.setUpdateBy("jobSystem");
            long startTime = System.currentTimeMillis();
            final CountDownLatch workCount = ThreadUtil.newCountDownLatch((int)6);
            ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor((int)6, (int)6);
            threadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        IndexReportService.this.reportProblemPersonService.generateReport();
                    }
                    catch (Exception e) {
                        IndexReportService.this.logger.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                    finally {
                        workCount.countDown();
                    }
                }
            });
            threadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        IndexReportService.this.reportPersonService.generateReport();
                    }
                    catch (Exception e) {
                        IndexReportService.this.logger.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                    finally {
                        workCount.countDown();
                    }
                }
            });
            threadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        IndexReportService.this.reportCompanyService.generateReport();
                    }
                    catch (Exception e) {
                        IndexReportService.this.logger.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                    finally {
                        workCount.countDown();
                    }
                }
            });
            threadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        IndexReportService.this.reportTrainService.generateReport();
                    }
                    catch (Exception e) {
                        IndexReportService.this.logger.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                    finally {
                        workCount.countDown();
                    }
                }
            });
            threadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        IndexReportService.this.reportPersoncertificateService.generateReport();
                    }
                    catch (Exception e) {
                        IndexReportService.this.logger.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                    finally {
                        workCount.countDown();
                    }
                }
            });
            threadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        IndexReportService.this.reportTaskService.generateReport();
                    }
                    catch (Exception e) {
                        IndexReportService.this.logger.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                    finally {
                        workCount.countDown();
                    }
                }
            });
            try {
                workCount.await();
            }
            catch (InterruptedException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            finally {
                threadPoolExecutor.shutdown();
            }
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(IndexReportService.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength(endTime - startTime + "ms");
            this.jobRunLogService.insert(log);
        }
    }
}

