/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.problemPerson;

import cn.hutool.core.thread.ThreadUtil;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.timer.problemPerson.ProblemPersonServiceJob;
import com.bcxin.ars.util.spring.util.SpringUtils;
import com.bcxin.ars.webservice.BackGroupCensorService;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ProblemPersonReScreenServiceJob {
    private Logger logger = LoggerFactory.getLogger(ProblemPersonReScreenServiceJob.class);
    @Autowired
    private SecurityPersonService securityPersonService;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private JobRunLogService jobRunLogService;
    private static BackGroupCensorService backGroupCensorService;
    @Value(value="${ZAFLAG}")
    private String ZAFLAG;
    private boolean lock = false;
    private int backGroupFrequency = 14;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block21: {
            if (this.lock) {
                return;
            }
            this.lock = true;
            try {
                long startTime;
                JobRunLog log;
                block22: {
                    String bg_switch = this.configUtils.getValueByKey("bg_switch");
                    if ("0".equals(bg_switch)) {
                        return;
                    }
                    if (backGroupCensorService == null) {
                        backGroupCensorService = (BackGroupCensorService)SpringUtils.getBean((String)("backGroupCensorService_" + this.configUtils.getCurrentProvince()));
                    }
                    if ("61".equals(this.configUtils.getCurrentNative())) {
                        return;
                    }
                    if (!this.configUtils.isIntranet() || this.ZAFLAG == null || !"1".equals(this.ZAFLAG)) break block21;
                    log = new JobRunLog();
                    log.setCreateTime(new Date());
                    log.setActive(Boolean.valueOf(true));
                    log.setUpdateBy("jobSystem");
                    startTime = System.currentTimeMillis();
                    try {
                        List personList = this.securityPersonService.findReCensor(this.backGroupFrequency);
                        if (personList.size() <= 0) break block22;
                        int limit = 100;
                        int count = new Double(Math.ceil((double)personList.size() * 1.0 / (double)limit)).intValue();
                        List subList = null;
                        for (int i = 0; i < count; ++i) {
                            subList = personList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                            final CountDownLatch countDownLatch = ThreadUtil.newCountDownLatch((int)subList.size());
                            ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor((int)15, (int)15);
                            for (final SecurityPerson securityPerson : subList) {
                                threadPoolExecutor.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            BackgroundApprovalDto dto = new BackgroundApprovalDto();
                                            dto.setIdNumber(securityPerson.getIdNumber());
                                            dto.setRealName(securityPerson.getRealName());
                                            dto.setBusinessid(securityPerson.getId());
                                            dto.setBusinesstype("15");
                                            dto.setAuthState(securityPerson.getIdentityAuthState());
                                            List backgroundApprovals = backGroupCensorService.censor(dto);
                                            securityPerson.setBackgroundApprovals(backgroundApprovals);
                                            securityPerson.setCensorStatusError(Boolean.valueOf(false));
                                        }
                                        catch (Exception e) {
                                            securityPerson.setCensorStatusError(Boolean.valueOf(true));
                                            ProblemPersonReScreenServiceJob.this.logger.error(e.getMessage(), (Throwable)e);
                                        }
                                        finally {
                                            countDownLatch.countDown();
                                        }
                                    }
                                });
                            }
                            try {
                                countDownLatch.await();
                            }
                            catch (InterruptedException e) {
                                this.logger.error(e.getMessage(), (Throwable)e);
                                e.printStackTrace();
                                Thread.currentThread().interrupt();
                            }
                            finally {
                                threadPoolExecutor.shutdown();
                            }
                            final CopyOnWriteArrayList successPersonList = new CopyOnWriteArrayList();
                            final CountDownLatch countDownLatch1 = ThreadUtil.newCountDownLatch((int)subList.size());
                            ThreadPoolExecutor threadPoolExecutor1 = ThreadUtil.newExecutor((int)30, (int)30);
                            for (final SecurityPerson securityPerson : subList) {
                                threadPoolExecutor1.execute(new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        try {
                                            Boolean result = false;
                                            if (securityPerson.getBackgroundApprovals() != null && securityPerson.getBackgroundApprovals().size() > 0) {
                                                for (BackgroundApproval backgroundApproval : securityPerson.getBackgroundApprovals()) {
                                                    if (!"004".equals(backgroundApproval.getApprovalstate())) continue;
                                                    result = true;
                                                }
                                            }
                                            if (!securityPerson.getCensorStatusError().booleanValue()) {
                                                if (result.booleanValue()) {
                                                    backGroupCensorService.censorSaveProblemPerson(securityPerson, securityPerson.getBackgroundApprovals());
                                                } else {
                                                    successPersonList.add(securityPerson);
                                                }
                                            }
                                        }
                                        catch (Exception e) {
                                            ProblemPersonReScreenServiceJob.this.logger.error(e.getMessage(), (Throwable)e);
                                            e.printStackTrace();
                                        }
                                        finally {
                                            countDownLatch1.countDown();
                                        }
                                    }
                                });
                            }
                            try {
                                countDownLatch1.await();
                            }
                            catch (InterruptedException e) {
                                this.logger.error(e.getMessage(), (Throwable)e);
                            }
                            threadPoolExecutor1.shutdown();
                            if (successPersonList == null || successPersonList.size() <= 0) continue;
                            this.securityPersonService.updateCensorStatusList(successPersonList);
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        log.setExceptionMsg(e.toString());
                        e.printStackTrace();
                    }
                }
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(ProblemPersonServiceJob.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength(endTime - startTime + "ms");
                this.jobRunLogService.insert(log);
            }
            finally {
                this.lock = false;
            }
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println(1 / 0);
        }
        catch (Exception e) {
            System.out.println(1 / 0);
        }
        finally {
            System.out.println("1111");
        }
        System.out.println("222");
    }
}

