/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.police;

import cn.hutool.core.thread.ThreadUtil;
import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.sb.BackgroundApprovalService;
import com.bcxin.ars.service.sb.PersoncertificateService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.spring.util.SpringUtils;
import com.bcxin.ars.webservice.BackGroupCensorService;
import com.bcxin.ars.webservice.police.SecurityInterfaceService;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PersonCensorJob {
    private Logger logger = LoggerFactory.getLogger(PersonCensorJob.class);
    @Autowired
    private PersoncertificateService personcertificateService;
    @Value(value="${timeFlag}")
    private String timeFlag = "";
    @Autowired
    private BackgroundApprovalService backgroundApprovalService;
    private static BackGroupCensorService backGroupCensorService;
    @Autowired
    private ConfigUtils configUtils;
    private boolean lock = false;

    private void getBackGroupCensorService() {
        if (backGroupCensorService == null) {
            backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JobLogAnnotation(getJobClazz=PersonCensorJob.class)
    public void run() {
        block20: {
            if (this.lock) {
                return;
            }
            this.lock = true;
            try {
                String bg_switch = this.configUtils.getValueByKey("bg_switch");
                if ("0".equals(bg_switch)) {
                    return;
                }
                if (!"61".equals(this.configUtils.getCurrentNative())) {
                    return;
                }
                if (!this.configUtils.isIntranet() || !this.timeFlag.equals("true")) break block20;
                try {
                    List personcertificateList = this.personcertificateService.findNoCensorStatus();
                    if (personcertificateList.size() > 0) {
                        SecurityInterfaceService securityInterfaceService = (SecurityInterfaceService)SpringUtils.getBean((String)("securityInterfaceService_" + this.configUtils.getCurrentProvince()));
                        int limit = 5;
                        int count = new Double(Math.ceil((double)personcertificateList.size() * 1.0 / (double)limit)).intValue();
                        List subList = null;
                        for (int i = 0; i < count; ++i) {
                            subList = personcertificateList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                            securityInterfaceService.censorNewQualification(subList);
                            final CountDownLatch countDownLatch1 = ThreadUtil.newCountDownLatch((int)subList.size());
                            ThreadPoolExecutor threadPoolExecutor1 = ThreadUtil.newExecutor((int)15, (int)15);
                            for (final Personcertificate personcertificate : subList) {
                                threadPoolExecutor1.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            if (!personcertificate.getCensorStatusError().booleanValue()) {
                                                PersonCensorJob.this.personcertificateService.updateCensorStatusForAuto(personcertificate, personcertificate.getBackgroundApprovals());
                                            }
                                        }
                                        catch (Exception e) {
                                            PersonCensorJob.this.logger.error(e.getMessage(), (Throwable)e);
                                        }
                                        finally {
                                            countDownLatch1.countDown();
                                        }
                                    }
                                });
                            }
                            try {
                                countDownLatch1.await();
                                continue;
                            }
                            catch (InterruptedException e) {
                                this.logger.error(e.getMessage(), (Throwable)e);
                                Thread.currentThread().interrupt();
                                continue;
                            }
                            finally {
                                threadPoolExecutor1.shutdown();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                this.lock = false;
            }
        }
    }
}

