/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.dataSync;

import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.dao.FilerecordDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Filerecord;
import com.bcxin.ars.model.datasync.FileRecordDetail;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.DataSyncUtil;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.HttpClientUtils;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DataSyncInToOutService {
    private static final Logger logger = LoggerFactory.getLogger(DataSyncInToOutService.class);
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private FilerecordDao fileRecordDao;
    @Autowired
    private DataSyncUtil dataSyncUtil;
    @Value(value="${uploadInToOutFolder}")
    private String uploadInToOutFolder;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;
    @Value(value="${timeFlag}")
    private String timeFlag = "";
    private boolean lock = false;
    private String BJ_OUT_URL = "http://61.51.205.18:8804/ars-rest/uploadFileGxToBj.do";
    private String GX_IN_URL = "http://10.148.77.214:8018/ars-rest/uploadFileBjToGx.do";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JobLogAnnotation(getJobClazz=DataSyncInToOutService.class)
    public void run() {
        if (this.lock) {
            return;
        }
        this.lock = true;
        try {
            Config config = this.configUtils.getConfigByKey("police");
            Config provinceConfig = this.configUtils.getConfigByKey("current_native");
            Config autoConfig = this.configUtils.getConfigByKey("autoDataSync");
            if ("true".equals(this.timeFlag) && autoConfig != null && "1".equals(autoConfig.getValue())) {
                if (provinceConfig != null && "11".equals(provinceConfig.getValue()) && config != null && "1".equals(config.getValue())) {
                    this.createDataFile();
                }
                if (provinceConfig != null && "45".equals(provinceConfig.getValue()) && config != null && "0".equals(config.getValue())) {
                    this.readDSFileGX(this.uploadInToOutFolder);
                }
            }
        }
        finally {
            this.lock = false;
        }
    }

    private void createDataFile() {
        if ("1".equals(this.configUtils.getValueByKey("DATASYNC_SWITCH"))) {
            logger.error("\u4f7f\u7528\u65b0\u540c\u6b65\u6446\u6e21");
            return;
        }
        logger.error("\u4f7f\u7528\u65e7\u540c\u6b65\u6446\u6e21");
        String startDate = DateUtil.getYesterday();
        Config lastDateConfig = this.configUtils.getConfigByKey("dataSyncLastDate");
        if (lastDateConfig != null && !DateUtil.convertDateToString((Date)new Date(), (String)"yyyy-MM-dd").equals(lastDateConfig.getValue())) {
            startDate = lastDateConfig.getValue();
        }
        String dirDate = DateUtil.getCurrentDate();
        String filePath = this.uploadInToOutFolder + dirDate + File.separatorChar;
        String resultPath = this.dataSyncUtil.createDSFile(startDate, filePath);
        try {
            AjaxResult ajaxResult = HttpClientUtils.FilePost((String)this.GX_IN_URL, (File)new File(resultPath));
            if (ajaxResult.isSuccessful()) {
                Config updateConfig = new Config();
                updateConfig.setKey("dataSyncLastDate");
                updateConfig.setValue(DateUtil.getCurrentDate());
                this.configUtils.updateForKey(updateConfig);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void readDSFileGX(String filePath) {
        Date now = new Date();
        Config lastDateConfig = this.configUtils.getConfigByKey("dataSyncLastDateForBJ");
        if (lastDateConfig != null) {
            String lastDate = lastDateConfig.getValue();
            List dates = DateUtil.getBetweenDates((Date)DateUtil.convertStringToDate((String)lastDate), (Date)now);
            dates.add(now);
            for (Date date : dates) {
                String dirFilePath = filePath + DateUtil.convertDateToString((Date)date, (String)"yyyy-MM-dd");
                File dirFile = new File(dirFilePath);
                if (!dirFile.exists()) continue;
                File[] files = dirFile.listFiles();
                boolean errorFlag = false;
                for (int i = 0; i < files.length; ++i) {
                    List fileRecordList;
                    File file = files[i];
                    if (!file.getName().endsWith(".zip") || (fileRecordList = this.fileRecordDao.findByFileName(file.getName(), this.configUtils.isIntranet())) != null && fileRecordList.size() != 0) continue;
                    try {
                        AjaxResult result = HttpClientUtils.FilePost((String)this.BJ_OUT_URL, (File)file);
                        if (result != null && result.isSuccessful()) {
                            this.saveFileRecord(null, file.getName(), file.getAbsolutePath(), null);
                            continue;
                        }
                        errorFlag = true;
                        continue;
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        errorFlag = true;
                    }
                }
                if (errorFlag) continue;
                Config updateConfig = new Config();
                updateConfig.setKey("dataSyncLastDateForBJ");
                updateConfig.setValue(DateUtil.getCurrentDate());
                this.configUtils.updateForKey(updateConfig);
            }
        }
    }

    private void saveFileRecord(List<FileRecordDetail> errorDetailList, String fileName, String filePath, Integer recordSize) {
        Filerecord fileRecord = new Filerecord();
        fileRecord.setId(Long.valueOf(this.idGeneratorUtil.createID()));
        fileRecord.setFilename(fileName);
        fileRecord.setFilepath(filePath);
        fileRecord.setRecordsize(recordSize);
        fileRecord.setCreateTime(new Date());
        fileRecord.setUpdateflag(Boolean.valueOf(true));
        fileRecord.setUpdateTime(new Date());
        fileRecord.setSynchtype("datasync");
        if (this.configUtils.isIntranet()) {
            fileRecord.setUpdateflag(Boolean.valueOf(true));
        }
        fileRecord.setIntranet(Boolean.valueOf(this.configUtils.isIntranet()));
        this.fileRecordDao.save(fileRecord);
    }
}

