/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.dataSync;

import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.dao.FilerecordDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Filerecord;
import com.bcxin.ars.model.datasync.FileRecordDetail;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.timer.dataSync.ApprovalSynchronizationService;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.HttpClientUtils;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DataSyncInToOutAuthService {
    private static final Logger logger = LoggerFactory.getLogger(ApprovalSynchronizationService.class);
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private FilerecordDao fileRecordDao;
    @Value(value="${uploadInToOutAuthFolder}")
    private String uploadInToOutAuthFolder;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;
    @Value(value="${timeFlag}")
    private String timeFlag = "";
    private String BJ_OUT_URL = "http://61.51.205.18:8804/authentication/identityauth/uploadFileGxToAuthBj.do";

    @JobLogAnnotation(getJobClazz=ApprovalSynchronizationService.class)
    public void run() {
        Config config = this.configUtils.getConfigByKey("police");
        Config provinceConfig = this.configUtils.getConfigByKey("current_native");
        if ("true".equals(this.timeFlag) && provinceConfig != null && "45".equals(provinceConfig.getValue()) && config != null && "0".equals(config.getValue())) {
            this.readDSFileGXAuth(this.uploadInToOutAuthFolder);
        }
    }

    private void readDSFileGXAuth(String filePath) {
        Date now = new Date();
        Config lastDateConfig = this.configUtils.getConfigByKey("dataSyncLastDateForAuthBJ");
        if (lastDateConfig != null) {
            String lastDate = lastDateConfig.getValue();
            List dates = DateUtil.getBetweenDates((Date)DateUtil.convertStringToDate((String)lastDate), (Date)now);
            dates.add(now);
            for (Date date : dates) {
                String dirFilePath = filePath + DateUtil.convertDateToString((Date)date, (String)"yyyy-MM-dd");
                File dirFile = new File(dirFilePath);
                if (!dirFile.exists()) continue;
                File[] files = dirFile.listFiles();
                boolean errorFlag = false;
                for (int i = 0; i < files.length; ++i) {
                    List fileRecordList;
                    File file = files[i];
                    if (!file.getName().endsWith(".zip") || (fileRecordList = this.fileRecordDao.findByFileName(file.getName(), this.configUtils.isIntranet())) != null && fileRecordList.size() != 0) continue;
                    try {
                        AjaxResult result = HttpClientUtils.FilePost((String)this.BJ_OUT_URL, (File)file);
                        if (result != null && result.isSuccessful()) {
                            this.saveFileRecord(null, file.getName(), file.getAbsolutePath(), null);
                            continue;
                        }
                        errorFlag = true;
                        continue;
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        errorFlag = true;
                    }
                }
                if (errorFlag) continue;
                Config updateConfig = new Config();
                updateConfig.setKey("dataSyncLastDateForAuthBJ");
                updateConfig.setValue(DateUtil.getCurrentDate());
                this.configUtils.updateForKey(updateConfig);
            }
        }
    }

    private void saveFileRecord(List<FileRecordDetail> errorDetailList, String fileName, String filePath, Integer recordSize) {
        Filerecord fileRecord = new Filerecord();
        fileRecord.setId(Long.valueOf(this.idGeneratorUtil.createID()));
        fileRecord.setFilename(fileName);
        fileRecord.setFilepath(filePath);
        fileRecord.setRecordsize(recordSize);
        fileRecord.setCreateTime(new Date());
        fileRecord.setUpdateflag(Boolean.valueOf(true));
        fileRecord.setUpdateTime(new Date());
        fileRecord.setSynchtype("datasync");
        if (this.configUtils.isIntranet()) {
            fileRecord.setUpdateflag(Boolean.valueOf(true));
        }
        fileRecord.setIntranet(Boolean.valueOf(this.configUtils.isIntranet()));
        this.fileRecordDao.save(fileRecord);
    }
}

