/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.dataSync;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.DataSyncContantsUtil;
import com.bcxin.ars.service.util.DataSyncUtil;
import com.bcxin.ars.util.DateUtil;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSyncDSServiceAll {
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private DataSyncUtil dataSyncUtil;
    @Autowired
    private DataSyncContantsUtil dataSyncContantsUtil;
    private boolean lock = false;

    @JobLogAnnotation(getJobClazz=DataSyncDSServiceAll.class)
    public void runAll() {
        if (this.lock) {
            return;
        }
        this.lock = true;
        try {
            if ("1".equals(this.configUtils.getValueByKey("datasynchronization")) && "true".equals(this.configUtils.timeFlag)) {
                if (!this.configUtils.isIntranet()) {
                    DataSynchronizationSearchDto searchDto = new DataSynchronizationSearchDto();
                    searchDto.setPaging(false);
                    searchDto.setStartDate(DateUtil.getYesterday());
                    searchDto.setEndDate(DateUtil.getTomorrow());
                    this.policeOutCreateFile(searchDto);
                } else {
                    this.policeInCreateFile();
                }
            }
        }
        finally {
            this.lock = false;
        }
    }

    private void policeOutCreateFile(DataSynchronizationSearchDto searchDto) {
        if ("1".equals(this.configUtils.getValueByKey("DATASYNC_SWITCH"))) {
            this.dataSyncUtil.createDSFile(DataSyncAnnotation.class, searchDto, this.dataSyncContantsUtil.ftpOutFolder + DateUtil.getCurrentDate() + File.separator);
        } else {
            this.dataSyncUtil.createDSFile(DataSyncAnnotation.class, searchDto, this.dataSyncContantsUtil.ftpFolder + DateUtil.getCurrentDate() + File.separator);
        }
    }

    private void policeInCreateFile() {
        if ("1".equals(this.configUtils.getValueByKey("DATASYNC_SWITCH"))) {
            String startDate = DateUtil.getYesterday();
            String dirDate = DateUtil.getCurrentDate();
            String filePath = this.dataSyncContantsUtil.ftpInFolder + dirDate + File.separatorChar;
            this.dataSyncUtil.createDSFile(startDate, filePath);
        }
    }
}

