/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.dataSync;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.DataSyncUtil;
import com.bcxin.ars.util.DateUtil;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DataSyncDSService {
    private Logger logger = LoggerFactory.getLogger(DataSyncDSService.class);
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private DataSyncUtil dataSyncUtil;
    @Value(value="${ftp-folder}")
    private String ftpFolder;
    private boolean lock = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JobLogAnnotation(getJobClazz=DataSyncDSService.class)
    public void run() {
        if (this.lock) {
            return;
        }
        this.lock = true;
        try {
            if ("1".equals(this.configUtils.getValueByKey("DATASYNC_SWITCH"))) {
                return;
            }
            Config datasynchronizationconfig = this.configUtils.getConfigByKey("datasynchronization");
            if (datasynchronizationconfig != null && "1".equals(datasynchronizationconfig.getValue()) && "true".equals(this.configUtils.timeFlag)) {
                if (this.configUtils.isIntranet()) {
                    this.policeInReadFile();
                } else {
                    DataSynchronizationSearchDto searchDto = new DataSynchronizationSearchDto();
                    searchDto.setPaging(false);
                    Config lastDateTimeConfig = this.configUtils.getConfigByKey("lastDateTime");
                    if (lastDateTimeConfig == null || DateUtil.convertDateToString((Date)new Date(), (String)"yyyy-MM-dd").equals(lastDateTimeConfig.getValue())) {
                        searchDto.setStartDate(DateUtil.getYesterdayTime());
                    } else {
                        searchDto.setStartDate(lastDateTimeConfig.getValue());
                    }
                    searchDto.setEndDate(DateUtil.getTomorrowTime());
                    this.policeOutCreateFile(searchDto);
                    Config updateConfig = new Config();
                    updateConfig.setKey("lastDateTime");
                    updateConfig.setValue(DateUtil.getDateStrAfterMinute((int)-5));
                    updateConfig.setUpdateTime(new Date());
                    this.configUtils.updateForKey(updateConfig);
                }
            }
        }
        finally {
            this.lock = false;
        }
    }

    private void policeInReadFile() {
        Date now = new Date();
        Config lastDateConfig = this.configUtils.getConfigByKey("lastDate");
        if (lastDateConfig != null) {
            String lastDate = lastDateConfig.getValue();
            List dates = DateUtil.getBetweenDates((Date)DateUtil.convertStringToDate((String)lastDate), (Date)now);
            dates.add(now);
            for (Date date : dates) {
                String dirFilePath = this.ftpFolder + DateUtil.convertDateToString((Date)date, (String)"yyyy-MM-dd");
                File dirFile = new File(dirFilePath);
                if (!dirFile.exists()) break;
                File[] files = dirFile.listFiles();
                boolean errorFlag = false;
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (!file.getName().endsWith(".zip") || !file.getName().startsWith(this.configUtils.getDataSyncStartFileName(DataSyncAnnotation.class))) continue;
                    try {
                        this.dataSyncUtil.readDSFile(DataSyncAnnotation.class, file);
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        errorFlag = true;
                    }
                }
                if (errorFlag) continue;
                Config updateConfig = new Config();
                updateConfig.setKey("lastDate");
                updateConfig.setValue(DateUtil.convertDateToString((Date)date, (String)"yyyy-MM-dd"));
                this.configUtils.updateForKey(updateConfig);
            }
        }
    }

    private void policeOutCreateFile(DataSynchronizationSearchDto searchDto) {
        this.dataSyncUtil.createDSFile(DataSyncAnnotation.class, searchDto, this.ftpFolder + DateUtil.getCurrentDate() + File.separator);
    }
}

