/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.dataSync;

import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.DataSyncUtil;
import com.bcxin.ars.util.DateUtil;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ApprovalSynchronizationService {
    private Logger logger = LoggerFactory.getLogger(ApprovalSynchronizationService.class);
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private DataSyncUtil dataSyncUtil;
    @Value(value="${time-approval-download-folder}")
    private String intToOutFolder;

    @JobLogAnnotation(getJobClazz=ApprovalSynchronizationService.class)
    public void runApproval() {
        if ("true".equals(this.configUtils.timeFlag)) {
            if ("1".equals(this.configUtils.getValueByKey("DATASYNC_SWITCH"))) {
                return;
            }
            Config config = this.configUtils.getConfigByKey("police");
            Config provinceConfig = this.configUtils.getConfigByKey("current_province");
            if (provinceConfig != null && ("610000".equals(provinceConfig.getValue()) || "450000".equals(provinceConfig.getValue()) || "640000".equals(provinceConfig.getValue()))) {
                if (config != null && "1".equals(config.getValue())) {
                    this.createDataFile();
                } else {
                    this.readDSFile(DataSyncOutAnnotation.class, this.intToOutFolder);
                }
            }
        }
    }

    private void createDataFile() {
        String startDate = DateUtil.getYesterday();
        Config lastDateConfig = this.configUtils.getConfigByKey("dataSyncLastDate");
        if (lastDateConfig != null && !DateUtil.convertDateToString((Date)new Date(), (String)"yyyy-MM-dd").equals(lastDateConfig.getValue())) {
            startDate = lastDateConfig.getValue();
        }
        String dirDate = DateUtil.getCurrentDate();
        String filePath = this.intToOutFolder + dirDate + File.separatorChar;
        this.dataSyncUtil.createDSFile(startDate, filePath);
        Config updateConfig = new Config();
        updateConfig.setKey("dataSyncLastDate");
        updateConfig.setValue(DateUtil.getCurrentDate());
        this.configUtils.updateForKey(updateConfig);
    }

    private void readDSFile(Class annotationClass, String filePath) {
        Date now = new Date();
        Config lastDateConfig = this.configUtils.getConfigByKey("dataSyncLastDate");
        if (lastDateConfig != null) {
            String lastDate = lastDateConfig.getValue();
            List dates = DateUtil.getBetweenDates((Date)DateUtil.convertStringToDate((String)lastDate), (Date)now);
            dates.add(DateUtil.getBeginDayOfYesterday());
            dates.add(now);
            for (Date date : dates) {
                String dirFilePath = filePath + DateUtil.convertDateToString((Date)date, (String)"yyyy-MM-dd");
                File dirFile = new File(dirFilePath);
                if (!dirFile.exists()) break;
                File[] files = dirFile.listFiles();
                boolean errorFlag = false;
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (!file.getName().endsWith(".zip") || !file.getName().startsWith(this.configUtils.getDataSyncStartFileName(DataSyncOutAnnotation.class))) continue;
                    try {
                        this.dataSyncUtil.readDSFile(annotationClass, file);
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        errorFlag = true;
                    }
                }
                if (errorFlag) continue;
                Config updateConfig = new Config();
                updateConfig.setKey("dataSyncLastDate");
                updateConfig.setValue(DateUtil.convertDateToString((Date)date, (String)"yyyy-MM-dd"));
                this.configUtils.updateForKey(updateConfig);
            }
        }
    }

    public static void main(String[] args) {
        File file = new File("C:\\data\\upload\\ars\\download\\approval\\2019-06-13\\datasync_20190613134530.zip");
        System.out.println(file.getAbsolutePath());
    }
}

