/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.company;

import com.bcxin.ars.dao.sb.ManagementInfoDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SAASMessageDto;
import com.bcxin.ars.dto.sb.ManagementInfoDto;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.SAASInterfaceUtil;
import com.bcxin.ars.util.StringUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ManagerInfoIncompleteNotifyService {
    private static final Logger logger = LoggerFactory.getLogger(ManagerInfoIncompleteNotifyService.class);
    @Resource
    private JobRunLogService jobRunLogService;
    @Resource
    private SAASInterfaceUtil saasInterfaceUtil;
    @Resource
    private ConfigUtils configUtils;
    @Resource
    private ManagementInfoDao managementInfoDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!"true".equals(this.configUtils.timeFlag) || !"11".equals(this.configUtils.getCurrentNative()) || this.configUtils.isIntranet()) {
            return;
        }
        JobRunLog log = this.getJobRunLog();
        long startTime = System.currentTimeMillis();
        try {
            this.handleInfoIncomplete();
        }
        catch (RuntimeException e) {
            logger.error("\u7ba1\u7406\u5c42\u4fe1\u606f\u4e0d\u5168\u7ad9\u5185\u4fe1\u63d0\u9192\u5f02\u5e38:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        finally {
            long endTime = System.currentTimeMillis();
            log.setRunTimeLength(endTime - startTime + "ms");
            log.setUpdateTime(new Date());
            this.jobRunLogService.insert(log);
        }
    }

    public void handleInfoIncomplete() {
        List managers = this.managementInfoDao.listWithComId();
        Map<String, List<ManagementInfoDto>> manageMap = managers.stream().collect(Collectors.groupingBy(ManagementInfoDto::getComId));
        HashMap<String, String> noJobMap = new HashMap<String, String>();
        String comId = null;
        String comIds = null;
        String jobs = null;
        List<ManagementInfoDto> manageList = null;
        for (Map.Entry<String, List<ManagementInfoDto>> entry : manageMap.entrySet()) {
            comId = entry.getKey();
            manageList = entry.getValue();
            jobs = "";
            boolean frJob = false;
            boolean zjlJob = false;
            boolean fzjlJob = false;
            boolean sjfzrJob = false;
            for (ManagementInfoDto managementInfoDto : manageList) {
                if (!StringUtil.isNotEmpty((String)managementInfoDto.getJobName())) continue;
                if (managementInfoDto.getJobName().contains("\u6cd5")) {
                    frJob = true;
                }
                if (managementInfoDto.getJobName().contains("\u526f")) {
                    fzjlJob = true;
                }
                if (managementInfoDto.getJobName().contains("\u5b9e\u9645\u8d1f\u8d23\u4eba")) {
                    sjfzrJob = true;
                }
                if (!managementInfoDto.getJobName().replaceAll("\u603b\u76d1", "").replaceAll("\u526f\u603b\u7ecf\u7406", "").contains("\u603b")) continue;
                zjlJob = true;
            }
            if (!frJob) {
                jobs = jobs + "\u6cd5\u5b9a\u4ee3\u8868\u4eba" + ",";
            }
            if (!zjlJob) {
                jobs = jobs + "\u603b\u7ecf\u7406" + ",";
            }
            if (!fzjlJob) {
                jobs = jobs + "\u526f\u603b\u7ecf\u7406" + ",";
            }
            if (!sjfzrJob) {
                jobs = jobs + "\u5b9e\u9645\u8d1f\u8d23\u4eba" + ",";
            }
            if (!StringUtil.isNotEmpty((String)jobs)) continue;
            comIds = (String)noJobMap.get(jobs);
            comIds = StringUtil.isEmpty((String)comIds) ? comId : comIds + "," + comId;
            noJobMap.put(jobs, comIds);
        }
        noJobMap.forEach((jobNames, ids) -> this.send((String)ids, "\u5173\u4e8e\u7ba1\u7406\u5c42\u4fe1\u606f\u4e0d\u5b8c\u6574\u7684\u901a\u77e5", "\u7ecf\u68c0\u67e5\uff0c\u8d35\u516c\u53f8\u7ba1\u7406\u5c42\u4fe1\u606f\u4e2d\u7f3a\u5c11:{jobs}\\n\u8bf7\u53ca\u65f6\u8865\u5145\u5b8c\u5584(\u9700\u81f3\u5c11\u5305\u542b\u4e00\u540d\u201c\u6cd5\u5b9a\u4ee3\u8868\u4eba\u201d\uff0c\u4e00\u540d\u201c\u603b\u7ecf\u7406\u201d\uff0c\u4ee5\u53ca\u4e00\u540d\u201c\u526f\u603b\u7ecf\u7406\u201d)\u3002\\n\u6dfb\u52a0\u8def\u5f84: [\u4f01\u4e1a\u7ba1\u7406] - [\u4f01\u4e1a\u62a5\u5907] - [\u7ba1\u7406\u5c42\u4fe1\u606f]- [\u65b0\u589e\u7ba1\u7406\u4eba\u5458]".replace("{jobs}", (CharSequence)jobNames)));
    }

    private JobRunLog getJobRunLog() {
        JobRunLog log = new JobRunLog();
        log.setCreateTime(new Date());
        log.setJobName(this.getClass().getName());
        log.setActive(Boolean.valueOf(true));
        log.setUpdateBy("jobSystem");
        log.setRunTime(new Date());
        return log;
    }

    public AjaxResult send(String companyIds, String title, String content) {
        logger.info(companyIds);
        logger.info(content);
        SAASMessageDto saasMessageDto = new SAASMessageDto();
        saasMessageDto.setComIds(companyIds);
        saasMessageDto.setTitle(title);
        saasMessageDto.setContent(content);
        saasMessageDto.setPoliceRegionId(this.configUtils.getCurrentProvince());
        saasMessageDto.setMessageType("050303");
        return this.saasInterfaceUtil.sendSaasMsg(saasMessageDto);
    }
}

