/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer;

import cn.jiguang.common.utils.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sys.BankAccountDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.sys.BankAccount;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.SAASInterfaceUtil;
import com.bcxin.ars.util.StringUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BankAccountToSaasService {
    private Logger logger = LoggerFactory.getLogger(BankAccountToSaasService.class);
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private BankAccountDao bankAccountDao;
    @Autowired
    private SAASInterfaceUtil saasInterfaceUtil;
    @Value(value="${timeFlag}")
    private String timeFlag = "";
    @Autowired
    private JobRunLogService jobRunLogService;

    public void sendToSaas() {
        if ("11".equals(this.configUtils.getCurrentNative()) && !this.configUtils.isIntranet() && this.timeFlag.equals("true")) {
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(Boolean.valueOf(true));
            log.setUpdateBy("jobSystem");
            long startTime = System.currentTimeMillis();
            try {
                List list = this.bankAccountDao.findUnPushToSAAS();
                int limit = 200;
                int count = new Double(Math.ceil((double)list.size() * 1.0 / (double)limit)).intValue();
                List subList = null;
                JSONArray paramArr = null;
                JSONObject param = null;
                for (int i = 0; i < count; ++i) {
                    try {
                        subList = list.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                        paramArr = new JSONArray();
                        for (BankAccount bankAccount : subList) {
                            bankAccount.setPush(Boolean.valueOf(true));
                            bankAccount.setUpdateTime(new Date());
                            param = new JSONObject();
                            param.put("perId", (Object)bankAccount.getPerId());
                            param.put("activeTime", (Object)bankAccount.getActiveDate());
                            param.put("openCardTime", (Object)bankAccount.getCardDate());
                            param.put("bankCode", (Object)"CBHB");
                            param.put("bankOutlets", (Object)bankAccount.getBankName());
                            if (StringUtil.isNotEmpty((String)bankAccount.getInitial())) {
                                if ("1".equals(bankAccount.getInitial())) {
                                    param.put("isActive", (Object)"0");
                                }
                                if ("0".equals(bankAccount.getInitial())) {
                                    param.put("isActive", (Object)"1");
                                }
                            }
                            param.put("bankNo", (Object)bankAccount.getBankNo());
                            param.put("bankCardNo", (Object)bankAccount.getCarNo());
                            param.put("bankAccountStatus", (Object)bankAccount.getState());
                            param.put("bankAccountType", (Object)bankAccount.getBankAccountType());
                            if (StringUtils.isNotEmpty((String)bankAccount.getFreezeDate())) {
                                param.put("cancelTime", (Object)bankAccount.getFreezeDate());
                            }
                            if (StringUtils.isNotEmpty((String)bankAccount.getReason())) {
                                param.put("cancelReason", (Object)bankAccount.getReason());
                            }
                            paramArr.add((Object)param);
                        }
                        HashMap<String, String> paramMap = new HashMap<String, String>();
                        paramMap.put("perJointlys", JSONObject.toJSONString((Object)paramArr));
                        AjaxResult result = this.saasInterfaceUtil.callInterface("/thirdPlat/bbd-callBack/batch-sync-per-jointly", paramMap);
                        if (!result.isSuccessful()) continue;
                        this.bankAccountDao.saveBatch(list);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error(e.getMessage(), (Throwable)e);
                log.setExceptionMsg(e.getMessage());
            }
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(BankAccountToSaasService.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength(endTime - startTime + "ms");
            this.jobRunLogService.insert(log);
        }
    }
}

