<%@ page contentType="text/html;charset=UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE html>
<html>
<head>
    <%@include file="/WEB-INF/views/include/head.jsp"%>
    <link href="${ctxStatic }/css/plugins/bootstrap-table/bootstrap-table.min.css?v=${version}" rel="stylesheet">
</head>
<body class="gray-bg">
<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-sm-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">
                    <form id="searchForm" class="form-horizontal">
                        <input type="hidden" name="state" value="1">
                        <div class="form-group">
                            <label class="col-sm-1 control-label">姓名</label>
                            <div class="col-sm-2">
                                <input type="text" class="form-control" id="name" name="name">
                            </div>
                            <label class="col-sm-1 control-label">身份证号</label>
                            <div class="col-sm-2">
                                <input type="text" class="form-control" id="cardnumber" name="cardnumber">
                            </div>
                            <label class="col-sm-1 control-label">保安员证号</label>
                            <div class="col-sm-2">
                                <input type="text" class="form-control" id="zsbh" name="zsbh">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-1 control-label">所属公司</label>
                            <div class="col-sm-2">
                                <input type="text" class="form-control" id="pxdwmc" name="pxdwmc">
                            </div>
                            <label class="col-sm-1 control-label">推送状态</label>
                            <div class="col-sm-2">
                                <select class="form-control m-b"  id="isDraw" name="isDraw">
                                    <option value="" data-code="" selected>全部</option>
                                    <option value="2" data-code="">未授权</option>
                                    <option value="0" data-code="">未推送</option>
                                    <option value="1" data-code="">已推送</option>
                                </select>
                            </div>


                            <label class="col-sm-1 control-label">是否有照片</label>
                            <div class="col-sm-2">
                                <select class="form-control m-b"  id="havephoto" name="havephoto">
                                    <option value="" data-code="" selected>全部</option>
                                    <option value="1" data-code="">是</option>
                                    <option value="0" data-code="">否</option>
                                </select>
                            </div>

                            <label class="col-sm-1 control-label">历史数据</label>
                            <div class="col-sm-2">
                                <select class="form-control m-b"  id="isOldData" name="isOldData">
                                    <option value="">全部</option>
                                    <option value="0" data-code="0">否</option>
                                    <option value="1" data-code="1">是</option>
                                </select>
                            </div>
                            <div class="col-sm-2">
                                <button class="btn btn-primary" type="button" onclick="reSearch();">搜索</button>
                            </div>
                        </div>
                    </form>
                    <div class="btn-group hidden-xs" id="tableEventsToolbar" role="group">
                        <a href="<c:url value='/manage/security/batchupdatestate.do?sid=${sid}&isMakeCard=0'/>" target="dialog" width="960px" height="600px" class="btn btn-primary">批量授权</a>

                        <a href="<c:url value='/manage/security/batchupdatestate.do?sid=${sid}&isMakeCard=1'/>" target="dialog" width="960px" height="600px" class="btn btn-primary">导出制卡数据</a>

                         <a href="<c:url value='/manage/security/batchexportAppPhoto.do?sid=${sid}'/>" target="dialog" width="360px" height="250px" class="btn btn-primary">导出app证件照</a>

                    </div>
                    <table id="defaultTable">
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<%@include file="/WEB-INF/views/include/foot.jsp"%>
<script src="${ctxStatic }/js/plugins/bootstrap-table/bootstrap-table.min.js?v=${version}"></script>
<script src="${ctxStatic }/js/plugins/bootstrap-table/locale/bootstrap-table-zh-CN.min.js?v=${version}"></script>
<script src="${ctxStatic }/js/tablePage.js?v=${version}"></script>
<script>
    $(function(){
        var objId = "defaultTable";
        var url = ctx + "/manage/security/searchForPage.json?sid=${sid}";
        var columns = [
            {title: 'id',field: 'id', visible: false, align: 'center',valign: 'middle'},
            {title: '姓名',field: 'name',align: 'center',valign: 'middle'},
            {title: '身份证号',field: 'idnum',align: 'center',valign: 'middle'},
            {title: '报名公司',field: 'companyName',align: 'center',valign: 'middle'},
            {title: '保安员证号',field: 'zsbh',align: 'center',valign: 'middle'},
            {title: '是否有照片',field: 'havephoto', align: 'center',valign: 'middle',
                formatter:function(value,row,index){
//                    return  (row.havephoto==true?"是":(row.havephoto==false?"否":"")) || '';
                    if(row.headImg){
                        return "是";
                    }
                    return "否";
                }
            },
            {title: '推送状态',field: 'isDraw', align: 'center',valign: 'middle',
                formatter:function(value,row,index){
                    if(value == '1'){
                        return "已推送";
                    }else if(value =='2'){
                        return "未授权";
                    }
                    return  "未推送";
                }
            },
            {title: '更新日期',field: 'updateTime',align: 'center',valign: 'middle'},
            {title: '操作',field: '#',align: 'center',
                formatter:function(value,row,index){
                    var d = '';
                    // if(row.isDraw=="2"){
                    //
                    //     d = d + '<a class="ml-10 btn btn-primary" href="'+ctx+'/securityCertificate/security/authorization/'+row.idnum+'.json?sid='+sid+'" target="ajaxTodo" title="确定授权？">授权</a>';
                    //
                    // }
                    d = d + '<a class="ml-10 btn btn-primary" href="' + ctx + '/manage/security/uploadHeadImg/' + row.idnum + '.do?sid='+sid+'" target="dialogDetail" width="960px" height="600px">上传证件照</a>';
                    d = d + '<a class="ml-10 btn btn-primary" href="javascript:viewPersonBaseImg(\''+row.idnum+'\')">使用人口库照片</a>';
                    d = d + '<a class="ml-10 btn btn-primary" href="javascript:viewIdPhoto(\''+row.idnum+'\')">使用APP证件照片</a>';
                    if(row.headImg){
                        d = d + '<a class="ml-10 btn btn-primary" href="javascript:viewHeadImg(\''+row.idnum+'\',\''+row.headImg+'\')">使用现有照片</a>';
                    }
                    return d;
                }
            }
        ];
        bootstrapTableInit(objId,url,columns);

        initLayerBtnClick();
    });

    
    function authorization(idnum) {
        $.ajax({
            type : 'POST',
            url : ctx + '/manage/security/authorization/' + idnum + '.do?sid'+sid,
            dataType : "json",
            //async :false,
            success : function(json) {
                if (json.successful == true || json.successful == "true") {
                }else{
                    toastrError(json.msg);
                }
                dialogAjaxDone(json);
            },error: function(xhr, ajaxOptions, thrownError){

                ajaxError(xhr, ajaxOptions, thrownError);
            }
        });
    }
    
    function viewPersonBaseImg(idnum){
        var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
        $.ajax({
            type : 'POST',
            url : ctx + '/manage/security/viewPersonBaseImg/' + idnum + '.do',
            dataType : "json",
            //async :false,
            success : function(json) {
                layer.close(loadIndex);
                if (json.successful == true || json.successful == "true") {
                    layer.open({
                        type : 1,
                        title : "使用人口库照片",
                        closeBtn : 1,
                        shadeClose : false,
                        scrollbar : false,
                        area : [ "300px", "400px"],
                        content : "<div style='text-align: center;padding: 20px;'><img style='width: 200px;height: 250px' src='"+ctx+"/"+json.data+"'/></div>",
                        skin : 'popup',
                        btn : [ "确定", "取消" ],
                        yes : function(indexIframe, layero) {
                            var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
                            $.ajax({
                                type : 'POST',
                                url : ctx + '/manage/security/usePersonBaseImg/' + idnum + '.do',
                                dataType : "json",
                                //async :false,
                                success : function(json) {
                                    layer.close(loadIndex);
                                    dialogAjaxDone(json);
                                },error: function(xhr, ajaxOptions, thrownError){
                                    layer.close(loadIndex);
                                    ajaxError(xhr, ajaxOptions, thrownError);
                                }
                            });
                        }
                    });
                }else{
                    toastrError(json.msg);
                }
            },error: function(xhr, ajaxOptions, thrownError){
                layer.close(loadIndex);
                ajaxError(xhr, ajaxOptions, thrownError);
            }
        });
    }
    function viewIdPhoto(idnum){
        var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
        $.ajax({
            type : 'POST',
            url : ctx + '/manage/security/viewIdPhoto/' + idnum + '.do',
            dataType : "json",
            //async :false,
            success : function(json) {
                layer.close(loadIndex);
                if (json.successful == true || json.successful == "true") {
                    layer.open({
                        type : 1,
                        title : "使用APP证件照片",
                        closeBtn : 1,
                        shadeClose : false,
                        scrollbar : false,
                        area : [ "300px", "400px"],
                        content : "<div style='text-align: center;padding: 20px;'><img style='width: 200px;height: 250px' src='"+ctx+"/"+json.data+"'/></div>",
                        skin : 'popup',
                        btn : [ "确定", "取消" ],
                        yes : function(indexIframe, layero) {
                            var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
                            $.ajax({
                                type : 'POST',
                                url : ctx + '/manage/security/useIdPhoto/' + idnum + '.do',
                                dataType : "json",
                                //async :false,
                                success : function(json) {
                                    layer.close(loadIndex);
                                    dialogAjaxDone(json);
                                },error: function(xhr, ajaxOptions, thrownError){
                                    layer.close(loadIndex);
                                    ajaxError(xhr, ajaxOptions, thrownError);
                                }
                            });
                        }
                    });
                }else{
                    toastrError(json.msg);
                }
            },error: function(xhr, ajaxOptions, thrownError){
                layer.close(loadIndex);
                ajaxError(xhr, ajaxOptions, thrownError);
            }
        });
    }
    function viewHeadImg(idnum,headImg){
        layer.open({
            type : 1,
            title : "使用现有照片",
            closeBtn : 1,
            shadeClose : false,
            scrollbar : false,
            area : [ "300px", "400px"],
            content : "<div style='text-align: center;padding: 20px;'><img style='width: 200px;height: 250px' src='"+ctx+"/"+headImg+"'/></div>",
            skin : 'popup',
            btn : [ "确定", "取消" ],
            yes : function(indexIframe, layero) {
                var loadIndex = layer.load(0, {shade: [0.3,'#808080']});
                $.ajax({
                    type : 'POST',
                    url : ctx + '/manage/security/resetDraw/' + idnum + '.do',
                    dataType : "json",
                    //async :false,
                    success : function(json) {
                        layer.close(loadIndex);
                        dialogAjaxDone(json);
                    },error: function(xhr, ajaxOptions, thrownError){
                        layer.close(loadIndex);
                        ajaxError(xhr, ajaxOptions, thrownError);
                    }
                });
            }
        });
    }
</script>
</body>
</html>
