package com.bcxin.ars.rest.sb;

import com.alibaba.fastjson.JSONArray;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.certificate.GradeAndCertificateDto;
import com.bcxin.ars.model.sb.PersonGrade;
import com.bcxin.ars.service.sb.PersonGradeService;
import com.bcxin.ars.service.util.ArsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * 等级证报名信息
 * @author linqinglin
 * @date 2019/12/31 0031 15:26
 */
@Controller
@RequestMapping("personGrade")
public class PersonGradeController {

    private static final Logger logger = LoggerFactory.getLogger(PersonGradeController.class);

    @Autowired
    private PersonGradeService personGradeService;

    @Autowired
    private ArsUtil arsUtil;

    /***
     * 保存等级证报名
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(PersonGrade personGrade){
        AjaxResult result = new AjaxResult();
        try {
            //TODO 变更状态 待审批
            personGradeService.save(personGrade);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /***
     * 修改比对信息
     */
    @RequestMapping("updateCompareInfo")
    @ResponseBody
    public AjaxResult updateCompareInfo(PersonGrade personGrade){
        AjaxResult result = new AjaxResult();
        try {
            personGradeService.updateCompareInfo(personGrade);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /***
     * 批量修改等级证报名
     */
    @RequestMapping("batchUpdate")
    @ResponseBody
    public AjaxResult batchUpdate(String personGrades){
        AjaxResult result = new AjaxResult();
        try {
            List<PersonGrade> list = JSONArray.parseArray(personGrades,PersonGrade.class);
            personGradeService.batchUpdate(list);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /***
     * 批量确认等级证成绩
     */
    @RequestMapping("batchUpdateScore")
    @ResponseBody
    public AjaxResult batchUpdateScore(String personGrades){
        AjaxResult result = new AjaxResult();
        try {
            List<PersonGrade> list = JSONArray.parseArray(personGrades,PersonGrade.class);
            personGradeService.batchUpdateScore(list);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     *
     * @param personIds
     * @return
     */
    @RequestMapping("checkPersonRegister")
    @ResponseBody
    public AjaxResult checkPersonRegister(Long[] personIds){
        AjaxResult result = new AjaxResult();
        try{
            List<GradeAndCertificateDto> gradeAndCertificateDtos = personGradeService.checkPersonRegister(personIds);
            result.setData(gradeAndCertificateDtos);
            result.setSuccessful(true);
        }catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     *
     * @param personIds
     * @return
     */
    @RequestMapping("checkPersonRegisterV2")
    @ResponseBody
    public AjaxResult checkPersonRegisterV2(Long[] personIds){
        AjaxResult result = new AjaxResult();
        try{
            List<GradeAndCertificateDto> gradeAndCertificateDtos = personGradeService.checkPersonRegisterV2(personIds);
            result.setData(gradeAndCertificateDtos);
            result.setSuccessful(true);
        }catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     *
     * 等级证报名增加对已持证数据校验，若人员已有同等级或更高级等级证书，则不可报名
     * (旧数据等级证)
     * @param personGrade
     * @return
     */
    @RequestMapping("checkPersonGradeCer")
    @ResponseBody
    public AjaxResult checkPersonGradeCer(PersonGrade personGrade){
        AjaxResult result = new AjaxResult();
        try{
            int count = personGradeService.checkPersonGradeCer(personGrade);
            result.setData(1);
            if(count >0){
                result.setData(0);
            }
            result.setSuccessful(true);
        }catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


}
