package com.bcxin.ars.rest.sb;

import com.alibaba.fastjson.JSONArray;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.sb.PersonAdapt;
import com.bcxin.ars.service.sb.PersonAdaptService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * 保安员岗位适应性报名控制器
 *
 * @author linqinglin
 * @Date 2020-04-10 10:39:21
 */
@Controller
@RequestMapping("personAdapt")
public class PersonAdaptController {

    Logger logger = LoggerFactory.getLogger(PersonAdaptController.class);

    @Autowired
    PersonAdaptService personAdaptService;

    /**
     * 保存
     * @param personAdapt
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(PersonAdapt personAdapt){
        AjaxResult result = new AjaxResult();
        try {
            personAdaptService.save(personAdapt);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }


    /***
     * 批量修改等级证报名
     */
    @RequestMapping("batchUpdate")
    @ResponseBody
    public AjaxResult batchUpdate(String personAdapts){
        AjaxResult result = new AjaxResult();
        try {
            List<PersonAdapt> list = JSONArray.parseArray(personAdapts,PersonAdapt.class);
            personAdaptService.batchUpdate(list);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}

