package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.GradeClassDto;
import com.bcxin.ars.rest.BaseController;
import com.bcxin.ars.service.sb.GradeClassService;
import com.bcxin.ars.service.util.ArsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/****
 * 等级证班级信息
 * @author  subh
 */
@Controller
@RequestMapping("gradeClass")
public class GradeClassController extends BaseController {
    /***
     * 日志
     */
    public static Logger logger = LoggerFactory.getLogger(GradeClassController.class);
    @Autowired
    private GradeClassService gradeClassService;
    @Autowired
    private ArsUtil arsUtil;
    /***
     * 保存班级信息
     */
    @RequestMapping("saveOrUpdate")
    public @ResponseBody
    AjaxResult saveOrUpdate(GradeClassDto dto){
        AjaxResult result = new AjaxResult();
        try {
            //当前用户
          /*  User currentUser = arsUtil.getCurrentUser();
            if(currentUser!=null) {*/
                gradeClassService.saveOrUpdate(dto);
                result.setSuccessful(true);
          /*  }else{
                result.setSuccessful(false);
                result.setMsg("找不到用户信息");
            }*/

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /***
     * 取消班级
     */
    @RequestMapping("cancelClass")
    public @ResponseBody
    AjaxResult cancelClass(GradeClassDto dto){
        AjaxResult result = new AjaxResult();
        try {
//            //当前用户
//            User currentUser = arsUtil.getCurrentUser();
//            if(currentUser!=null) {
                gradeClassService.updateCancelClass(dto);
                result.setSuccessful(true);
//            }else{
//                result.setSuccessful(false);
//                result.setMsg("找不到用户信息");
//            }

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /***
     * 更新班级人员信息
     */
    @RequestMapping("updateClassPersonInfo")
    public @ResponseBody AjaxResult updateClassPersonInfo(GradeClassDto dto){
        AjaxResult result = new AjaxResult();
        try {
//            //当前用户
//            User currentUser = arsUtil.getCurrentUser();
//            if(currentUser!=null) {
                gradeClassService.updateClassPersonInfo(dto);
                result.setSuccessful(true);
//            }else{
//                result.setSuccessful(false);
//                result.setMsg("找不到用户信息");
//            }

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
