package com.bcxin.ars.rest.dto;

import java.io.Serializable;

import org.apache.poi.ss.formula.functions.T;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.ars.util.DES3;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class AppAjaxResult implements Serializable {

	private static final long serialVersionUID = 4530474987109938356L;
	
	private boolean successful;
	private String requestCode;
	private String code;
	private String msg;
	private Object data;
	
	public boolean isSuccessful() {
		return successful;
	}
	public void setSuccessful(boolean successful) {
		this.successful = successful;
	}

	public String getRequestCode() {
		return requestCode;
	}
	public void setRequestCode(String requestCode) {
		this.requestCode = requestCode;
	}
	
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
	public String getMsg() {
		return msg;
	}
	public void setMsg(String msg) {
		this.msg = msg;
	}
	
	public Object getData() {
			return data;
	}

	@JsonIgnore
	public String getDecodeData() {
		try {
			return data == null? null:DES3.decode(data.toString());
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}
	
	@JsonIgnore
	public <T>T getDecodeData(Class<T> clazz){
		return JSON.parseObject(getDecodeData(), clazz);
	}
	
	public void setData(Object data) {
		this.data = data;
	}
	
	public void setEncodeData(Object data) {
		try {
			JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
			this.data = DES3.encode(JSON.toJSONString(data,SerializerFeature.WriteDateUseDateFormat));
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
