package com.bcxin.ars.rest.appeal;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.appeal.AppealSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.appeal.Appeal;
import com.bcxin.ars.service.appeal.AppealService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 申诉信息 控制层
 * @author linqinglin
 * @date 2019/12/05 0005 16:04
 */
@RequestMapping("appeal")
@Controller
public class AppealController {

    private static final Logger logger = LoggerFactory.getLogger(AppealController.class);

    @Autowired
    private AppealService appealService;
    @Autowired
    private ArsUtil arsUtil;

    @RequestMapping("save")
    public @ResponseBody
    AjaxResult save(Appeal appeal)   {
        AjaxResult result = new AjaxResult();
        try {
            //当前用户
//            User currentUser = arsUtil.getCurrentUser();
//            if(currentUser!=null) {
                appealService.save(appeal);
                result.setSuccessful(true);
//            }else{
//                result.setSuccessful(false);
//                result.setMsg("找不到用户信息");
//            }

        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

}
