package com.bcxin.ars.rest;


import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SecurityGoodThingDto;
import com.bcxin.ars.model.SecurityGoodThing;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.SecurityGoodThingService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;


/**
 * 保安員好人好事要闻
 * @author harve
 */
@Controller
@RequestMapping("securitygoodthing")
public class SecurityGoodThingController {

    private Logger logger = LoggerFactory.getLogger(SecurityGoodThingController.class);

    @Autowired
    private SecurityGoodThingService securityGoodThingService;

    @Value("${securitygoodthing-download-folder}")
    private String downloadFolder;

    /**
     * 更新保安员好人好事要闻
     * 通过id
     * @return
     */
    @RequestMapping("updateById")
    public @ResponseBody
    AjaxResult UpdateById(@Valid  SecurityGoodThing securityGoodThing) {
        AjaxResult result = new AjaxResult();
        try {
            SecurityGoodThing securityGoodThing1 = securityGoodThingService.updateById(securityGoodThing);
            result.setSuccessful(true);
            result.setData(securityGoodThing1);
        } catch(Exception e) {
            logger.error(e.getMessage(),e);
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    /**
     * 更新保安员好人好事要闻
     * 通过id
     * @return
     */
    @RequestMapping("deleteById")
    public @ResponseBody
    AjaxResult DeleteById(Long goodDeedsId){
        AjaxResult result = new AjaxResult();
        try {
            SecurityGoodThing securityGoodThing = securityGoodThingService.findByGoodDeedsId(goodDeedsId);
            if(null!=securityGoodThing) {
                securityGoodThingService.deleteGoodThingByGoodDeedsId(goodDeedsId);
                result.setSuccessful(true);
            } else {
                result.setSuccessful(false);
                result.setMsg("删除信息失败，goodDeedsId:" + goodDeedsId);
            }

        } catch(Exception e) {
            logger.error(e.getMessage(),e);
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    /**
     * 创建或更新保安员好人好事要闻
     * @param securityGoodThing 保安员好人好事要闻
     * @return
     */
    @RequestMapping("saveOrUpdate")
    public @ResponseBody AjaxResult update(@Valid SecurityGoodThing securityGoodThing, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            securityGoodThingService.saveOrUpdateForSAAS(securityGoodThing);
            result.setSuccessful(true);
        } catch(Exception e) {
            throw e;
        }
        return result;
    }


    /**
     * 新增好人好事要闻
     * @param securityGoodThing
     * @return
     */
    @RequestMapping("add")
    public @ResponseBody
    AjaxResult add(SecurityGoodThing securityGoodThing) {
        AjaxResult result = new AjaxResult();
        try {
            securityGoodThingService.save(securityGoodThing);
            result.setSuccessful(true);
        } catch(Exception e) {
            logger.error(e.getMessage(),e);
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }




}
