package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Investor;
import com.bcxin.ars.service.sb.InvestorService;
import com.bcxin.ars.service.util.ArsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.validation.Valid;
import java.math.BigDecimal;

@Controller
@RequestMapping("investor")
public class InvestorController {

	Logger logger = LoggerFactory.getLogger(InvestorController.class);
	
	@Autowired
	private InvestorService investorService;

	@Autowired
	private ArsUtil arsUtil;
	/***
	 * 保存或更新出资人信息
	 * @param investor 出资人信息信息
	 * @return 执行情况
	 */
	@RequestMapping("update")
	public @ResponseBody AjaxResult update(@Valid Investor investor) {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);

				//saas传的是元 转成万元
				if(investor.getFundedNumber() != null){
					investor.setFundedNumber(investor.getFundedNumber().divide(new BigDecimal(10000)));
				}

				investorService.saveOrUpdate(investor);
				result.setMsg("更新成功");
			} else {
				result.setSuccessful(false);
				result.setMsg("用户信息为空");
			}
		} catch(Exception e) {
			logger.error(e.getMessage(),e);
			result.setSuccessful(false);
			result.setMsg(e.getMessage());
		}
		return result;
	}

	/***
	 * 删除出资人信息
	 * @param investor 出资人信息
	 * @return 执行情况
	 */
	@RequestMapping("delete")
	public @ResponseBody AjaxResult delete(Investor investor) {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				investorService.delete(investor);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(),e);
			result.setSuccessful(false);
			result.setMsg(e.getMessage());
		}
		return result;
	}

}
