package com.bcxin.ars.filter;
import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 跨域访问拦截器
 *
 * @author zhangye
 * @version 1.0
 */
@WebFilter(urlPatterns={"/app/*","/uploadFile.do","/uploadFile.json","/integrated/*"})
public class CrossDomainFilter implements Filter {

    @Override
    public void init(FilterConfig config) throws ServletException {

    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain)
            throws IOException, ServletException {
    	HttpServletResponse response = (HttpServletResponse) res;
        HttpServletRequest request = (HttpServletRequest) req;
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Access-Control-Allow-Methods", "PUT,POST,GET,DELETE");
        response.setHeader("Access-Control-Allow-Headers",
                "x-requested-with,content-type,Content-type,authorization,x-csrf-token,access_token");
        response.setHeader("Content-type", "text/html;charset=UTF-8");
        response.setHeader("Content-type", "application/x-www-form-urlencoded; charset=UTF-8");
        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {

    }
}
