package com.bcxin.ars.rest.sb;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.GradePracticeSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.GradePractice;
import com.bcxin.ars.rest.BaseController;
import com.bcxin.ars.service.sb.GradePracticeService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;


/****
 * 等级证实习记录
 * @author  subh
 */
@Controller
@RequestMapping("gradePractice")
public class GradePracticeController extends BaseController {
    /***
     * 日志
     */
    public static Logger logger = LoggerFactory.getLogger(GradePracticeController.class);

    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private GradePracticeService gradePracticeService;
    @Autowired
    private ConfigUtils configUtils;
    /***
     * 保存实习记录信息
     * @param dto 实习记录信息
     * @return
     */
    @RequestMapping("saveOrUpdate")
    public @ResponseBody AjaxResult save(GradePractice dto){
        AjaxResult result = new AjaxResult();
        try {
         /*   User currentUser = arsUtil.getCurrentUser();
            if (currentUser != null) {*/
                gradePracticeService.saveOrUpdate(dto);
                result.setSuccessful(true);
        /*    }else{
                result.setSuccessful(false);
                result.setMsg("找不到用户信息");
            }*/
            return result;
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }

    /***
     * 删除实习记录信息
     * @param dto 实习记录信息
     * @return
     */
    @RequestMapping("del")
    public @ResponseBody AjaxResult del(GradePractice dto){
        AjaxResult result = new AjaxResult();
        try {
          /*  User currentUser = arsUtil.getCurrentUser();
            if (currentUser != null) {*/
                gradePracticeService.del(dto);
                result.setSuccessful(true);
           /* }else{
                result.setSuccessful(false);
                result.setMsg("找不到用户信息");
            }*/

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /***
     * SaaS查询实习记录
     * @param searchDto
     * @param page
     * @return
     * @throws Exception
     */
    @RequestMapping("searchForSAASPage")
    public @ResponseBody  AjaxPageResponse searchForSAASPage(GradePracticeSearchDto searchDto, AjaxPageResponse<GradePractice> page){
        try {
            User currentUser = arsUtil.getCurrentUser();
            if (currentUser != null) {
                gradePracticeService.query(searchDto,page);
                //图片地址转完整的访问地址，不然saas那边访问不了
                String webHost = configUtils.getWebHost();
                /***
                 * 穿戴保安服照、实习地点照片、实习过程照片、实习过程视频  地址转换
                 */
                List<GradePractice> data = page.getData();
                for (GradePractice gradePractice:
                        data ) {
                    /***
                     * 1.穿戴保安服照
                     */
                    if (StringUtil.isNotEmpty(gradePractice.getUniformImg())) {
                        gradePractice.setUniformImg(webHost  +gradePractice.getUniformImg());
                    }
                    /***
                     * 2.实习地点照片
                     */
                    if (StringUtil.isNotEmpty(gradePractice.getAddressImg())) {

                        gradePractice.setAddressImg(webHost  + gradePractice.getAddressImg()) ;
                    }
                    /***
                     * 3.实习过程照片
                     */
                    if (StringUtil.isNotEmpty(gradePractice.getProcessImg())) {
                        gradePractice.setProcessImg(webHost  + gradePractice.getProcessImg()) ;
                    }

                    /***
                     * 4.实习过程视频
                     */
                    if (StringUtil.isNotEmpty(gradePractice.getVideo())) {
                        gradePractice.setVideo(webHost  + gradePractice.getVideo());
                    }
                }
            }
            return page;
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }

}
