package com.bcxin.ars.rest.app;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bcxin.ars.dto.AppUpgradeDto;
import com.bcxin.ars.model.task.AppUpgrade;
import com.bcxin.ars.rest.dto.AppAjaxResult;
import com.bcxin.ars.service.task.AppUpgradeService;

@Controller
@RequestMapping("app/upgradeinfo")
public class AppUpgradeInfoController {

	private Logger logger = LoggerFactory.getLogger(AppUpgradeInfoController.class);

	@Autowired
	private AppUpgradeService appUpgradeService;

	/**
	 * 查询APP升级信息
	 *
	 * @param appUpgradeDto
	 *            APP升级信息参数
	 * @return
	 */
	@RequestMapping(value = "v-1-1-1/findAppUpgradeInfo", method = RequestMethod.POST)
	public @ResponseBody AppAjaxResult findAppUpgradeInfo(AppAjaxResult appResult) throws Exception {
		AppAjaxResult result = new AppAjaxResult();
		try {
			AppUpgradeDto appUpgradeDto = appResult.getDecodeData(AppUpgradeDto.class);
			AppUpgrade appUpgrade = appUpgradeService.findAppUpgradeInfo(appUpgradeDto);
			result.setSuccessful(true);
			result.setEncodeData(appUpgrade);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
