package com.bcxin.ars.rest.app;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bcxin.ars.model.MobileConfig;
import com.bcxin.ars.rest.dto.AppAjaxResult;
import com.bcxin.ars.service.MobileConfigService;
import com.bcxin.ars.util.Constants;

@Controller
@RequestMapping("app/config")
public class AppConfigController {

	private Logger logger = LoggerFactory.getLogger(AppConfigController.class);
	
	@Autowired
	private MobileConfigService mobileConfigService;
	
	/**
	 * 获取当前数据区域编号
	 * @param request
	 * @return
	 */
	@RequestMapping("getCurrentNative")
	public @ResponseBody AppAjaxResult getCurrentNative(HttpServletRequest request) {
		AppAjaxResult result = new AppAjaxResult();
		Object data = request.getSession().getServletContext().getAttribute(Constants.CURRENT_NATIVE);
		if(data != null) {
			result.setSuccessful(true);
			result.setEncodeData(data);
		} else {
			result.setSuccessful(false);
			result.setMsg("初始化错误，未找到常量数据。");
		}
		return result;
	}
	
	/**
	 * 获取血型分类
	 * @param request
	 * @return
	 */
	@RequestMapping("getBloodList")
	public @ResponseBody AppAjaxResult getBloodList(HttpServletRequest request) {
		AppAjaxResult result = new AppAjaxResult();
		Object data = request.getSession().getServletContext().getAttribute(Constants.BLOOD);
		if(data != null) {
			result.setSuccessful(true);
			result.setEncodeData(data);
		} else {
			result.setSuccessful(false);
			result.setMsg("初始化错误，未找到常量数据。");
		}
		return result;
	}
	
	/**
	 * 获取驾驶级别
	 * @param request
	 * @return
	 */
	@RequestMapping("getDrivingLevel")
	public @ResponseBody AppAjaxResult getDrivingLevel(HttpServletRequest request) {
		AppAjaxResult result = new AppAjaxResult();
		Object data = request.getSession().getServletContext().getAttribute(Constants.DRIVING_LEVEL);
		if(data != null) {
			result.setSuccessful(true);
			result.setEncodeData(data);
		} else {
			result.setSuccessful(false);
			result.setMsg("初始化错误，未找到常量数据。");
		}
		return result;
	}
	
	/**
	 * 获取性别
	 * @param request
	 * @return
	 */
	@RequestMapping("getGender")
	public @ResponseBody AppAjaxResult getGender(HttpServletRequest request) {
		AppAjaxResult result = new AppAjaxResult();
		Object data = request.getSession().getServletContext().getAttribute(Constants.GENDER);
		if(data != null) {
			result.setSuccessful(true);
			result.setEncodeData(data);
		} else {
			result.setSuccessful(false);
			result.setMsg("初始化错误，未找到常量数据。");
		}
		return result;
	}
	
	/**
	 * <b>Function </b> android app获得最新版本信息
	 * 
	 * @param request
	 * @return
	 * @author LinQingLin 
	 * @date 2017年2月23日 上午10:11:14
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("getAndroidVersion")
	public @ResponseBody AppAjaxResult getAndroidVersion(HttpServletRequest request) throws Exception {
		AppAjaxResult result = new AppAjaxResult();
		try {
			List<MobileConfig> adList =mobileConfigService.findByKeyForList(Constants.VERSION_ANDROID);
			result.setSuccessful(true);
			result.setEncodeData(adList);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * <b>Function </b> app获得引导页
	 * 
	 * @param request
	 * @return
	 * @author LinQingLin 
	 * @date 2017年2月23日 上午10:11:14
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("getGuidePage")
	public @ResponseBody AppAjaxResult getGuidePage(HttpServletRequest request) throws Exception {
		AppAjaxResult result = new AppAjaxResult();
		try {
			List<MobileConfig> guideList =mobileConfigService.findByKeyForList(Constants.GUIDE_PAGE);
			result.setSuccessful(true);
			result.setEncodeData(guideList);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * <b>Function </b> app获得广告页
	 * 
	 * @param request
	 * @return
	 * @author LinQingLin 
	 * @date 2017年2月23日 上午10:11:14
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("getAdPage")
	public @ResponseBody AppAjaxResult getAdPage(HttpServletRequest request) throws Exception {
		AppAjaxResult result = new AppAjaxResult();
		try {
			List<MobileConfig> adList =mobileConfigService.findByKeyForList(Constants.AD);
			if(adList!=null && adList.size()>0) {
				result.setSuccessful(true);
				result.setEncodeData(adList);
			}else{
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			result.setSuccessful(false);
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
