package com.bcxin.ars.rest;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.SbPunishSearchDto;
import com.bcxin.ars.model.SbPunish;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.SbPunishService;
import com.bcxin.ars.service.SecurityPersonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.List;

/**
 * 保安员处罚
 * <b>Function </b>
 * 
 * @author LinQingLin
 * @date 2017年8月2日 上午9:59:41
 * @注意事项 </b>
 * <b>
 */

@Controller
@RequestMapping("sbPunish")
public class SbPunishController {
	
	private static final Logger logger = LoggerFactory.getLogger(SbPunishController.class);

	@Autowired
	private SbPunishService sbPunishService;

	@Autowired
	private SecurityPersonService securityPersonService;

	@Autowired
	private ArsRestUtil arsUtil;


	/**
	 * 创建或更新保安奖励信息
	 * @param dto 保安奖励信息
	 * @return
	 */
	@RequestMapping("saveOrUpdate")
	public @ResponseBody AjaxResult update(SbPunishSearchDto dto, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<SbPunish> sbPunishList = JSON.parseArray(dto.getSbPunishList(), SbPunish.class);
			sbPunishService.saveOrUpdateForSAAS(sbPunishList);
			result.setSuccessful(true);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}
	/**
	 * 删除保安奖励信息
	 * @return
	 */
	@RequestMapping("delete")
	public @ResponseBody AjaxResult delete(Long penaltyId) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<SbPunish> sbPunishList = sbPunishService.findByPenaltyId(penaltyId);

			if(null!=sbPunishList  && sbPunishList.size()>0) {
				sbPunishService.deleteByPenaltyId(penaltyId);
					result.setSuccessful(true);
				} else {
					result.setSuccessful(false);
					result.setMsg("删除信息失败，penaltyId:" + penaltyId);
				}

		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}


}
