package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.PoliceDto;
import com.bcxin.ars.dto.sb.PoliceSearchDto;
import com.bcxin.ars.service.PoliceService;
import com.bcxin.ars.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * 机构相关接口
 * @author linqinglin
 * @date 2019/03/06 0006 13:35
 */
@Controller
@RequestMapping("police")
public class PoliceController {

    private static final Logger logger = LoggerFactory.getLogger(PoliceController.class);

    @Autowired
    private PoliceService policeService;

    /**
     * 机构查询
     * @param policeSearchDto
     * @return
     * @throws Exception
     */
    @RequestMapping("search")
    public @ResponseBody
    AjaxResult search(PoliceSearchDto policeSearchDto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            //如果上级机构id没传，查询市级机构
            if(policeSearchDto.getParentorg() == null){
                policeSearchDto.setOrgtype(Constants.POLICE_ORGTYPE_SHI);
            }
            List<PoliceDto> data = policeService.searchForSaas(policeSearchDto);
            result.setSuccessful(true);
            result.setData(data);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
