package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.ManagementInfoSearchDto;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.ManagementInfo;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.sb.ManagementInfoService;
import com.bcxin.ars.service.util.ArsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.validation.Valid;

@Controller
@RequestMapping("managementInfo")
public class ManagementInfoController {

	Logger logger = LoggerFactory.getLogger(ManagementInfoController.class);
	
	@Autowired
	private ManagementInfoService managementInfoService;

	
	@Autowired
	private ArsUtil arsUtil;
	

	@RequestMapping("update")
	public @ResponseBody AjaxResult update(@Valid ManagementInfo managementInfo) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				managementInfoService.saveOrUpdateForSaas(managementInfo);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	

	
	@RequestMapping("delete")
	public @ResponseBody AjaxResult delete(ManagementInfo managementInfo) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				managementInfoService.delete(managementInfo);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
