package com.bcxin.ars.rabbitmq;

import org.springframework.amqp.core.*;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.ChannelAwareMessageListener;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;

import java.util.Collections;

/**
 * Topic交换机配置
 * @author linqinglin
 * @date 2018/12/15 0015 11:21
 */
@Configuration
@PropertySource("classpath:rabbitmq.properties")
public class TopicExchangeConfig {

    @Autowired
    private Environment env;

    /**
     * 交换机
     * @return
     */
    @Bean
    public TopicExchange topicExchange() {
        return new TopicExchange(env.getProperty("rabbitmq.exchange"));
    }

    /**
     * 队列
     * @return
     */
    @Bean
    public Queue topicQueue() {
        return QueueBuilder.durable(env.getProperty("rabbitmq.produce.queuename")).build();
    }

    /**
     * 绑定
     * @param topicQueue
     * @param topicExchange
     * @return
     */
    @Bean
    public Binding binding(Queue topicQueue, TopicExchange topicExchange) {
        return BindingBuilder.bind(topicQueue).to(topicExchange).with(env.getProperty("rabbitmq.routingKey"));
    }


    /**
     * queue litener  观察 监听模式 当有消息到达时会通知监听在对应的队列上的监听对象
     * @param rabbitConnectionFactory
     * @param channelAwareMessageListener
     * @return
     */
    @Bean
    public SimpleMessageListenerContainer topicMessageListenerContainer(@Qualifier("rabbitConnectionFactory") ConnectionFactory rabbitConnectionFactory, @Qualifier("rabbitConsumer")ChannelAwareMessageListener channelAwareMessageListener){
        SimpleMessageListenerContainer container = new SimpleMessageListenerContainer();
        container.setConnectionFactory(rabbitConnectionFactory);
        container.setChannelAwareMessageListener(channelAwareMessageListener);
        container.setQueues(topicQueue());
        container.setConsumerArguments(Collections. <String, Object> singletonMap("x-priority", Integer.valueOf(10)));
        return container;
    }
}
