package com.bcxin.ars.dao;

import java.util.Date;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

import com.bcxin.ars.model.User;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-dao.xml" })
@Transactional
@TransactionConfiguration(transactionManager = "txManager", defaultRollback = true)
public class UserDaoTest {

	@Autowired
	private UserDao userDao;
	
	@Test
	public void testFindByUsername() {
		User user = userDao.findById(1l);
		Assert.assertNotNull(user);
	}
	
	@Test
	public void testSave(){
		User user = buildUser();
		userDao.save(user);
		User dbUser = userDao.findById(user.getId());
		Assert.assertNotNull(dbUser);
		Assert.assertFalse(dbUser.getInit());
	}
	
	public User buildUser() {
		User user = new User();
		user.setUsername("test123");
		user.setPassword("adsfasdf");
		user.setRealname("测试姓名");
		user.setPhone("139123123172");
		user.setNativeCode(Long.parseLong("23423"));
		user.setPlatform(3);
		user.setActive(true);
		user.setCreateTime(new Date());
		user.setUpdateTime(new Date());
		user.setUpdateBy("070");
		return user;
	}

}
