<%@ page language="java" contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<!DOCTYPE HTML>
<html>
<head>
<title>PSS勘查平台</title>
<link href="<c:url value='/resources/css/wechat/newweui.css'/>" rel="stylesheet"type="text/css">

<script type="text/javascript" src="<c:url value='/resources/js/jquery-2.1.1.min.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';

	function showMenu(objId) {
		$("#" + objId).show();
	}

	function hideMenu(objId) {
		$("#" + objId).hide();
	}
</script>
<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
</head>
<body>
	<div class="weui-tabbar">
		<a href="javascript:void(0);" class="weui-tabbar__item"
			onclick="showMenu('personCenter')">
			<p class="weui-tabbar__label weui-media__title">个人中心</p>
		</a> 
		<a href="javascript:void(0);" class="weui-tabbar__item" onclick="showMenu('survey')">
			<p class="weui-tabbar__label weui-media__title">现场勘查</p>
		</a> 
		<a href="javascript:void(0);" class="weui-tabbar__item" onclick="showMenu('venue')">
			<p class="weui-tabbar__label weui-media__title">场馆维护</p>
		</a>
	</div>

	<div id="personCenter" style="display: none;">
		<div class="weui-mask_transparent actionsheet__mask actionsheet__mask_show"
			style="display: block; transform-origin: 0px 0px 0px; opacity: 1; transform: scale(1, 1);"></div>
		<div class="weui-actionsheet weui-actionsheet_toggle" id="weui-actionsheet">
			<div class="weui-actionsheet__menu">
				<div class="weui-actionsheet__cell">
					<a href="<c:url value='/wechat/task/taskList/init'/>" target="_blank">我的任务</a>
				</div>
				<div class="weui-actionsheet__cell">
					<a href="<c:url value='/wechat/plan/surveyPlan/init'/>" target="_blank">我的日程</a>
				</div>
				<div class="weui-actionsheet__cell">
					<a href="<c:url value='/j_spring_security_logout'/>" target="_blank">退出</a>
				</div>
			</div>
			<div class="weui-actionsheet__action">
				<div class="weui-actionsheet__cell" id="actionsheet_cancel" onclick="hideMenu('personCenter')">取消</div>
			</div>
		</div>
	</div>


	<div id="survey" style="display: none;">
		<div class="weui-mask_transparent actionsheet__mask actionsheet__mask_show"
			style="display: block; transform-origin: 0px 0px 0px; opacity: 1; transform: scale(1, 1);"></div>
		<div class="weui-actionsheet weui-actionsheet_toggle" id="weui-actionsheet">
			<div class="weui-actionsheet__menu">
				<div class="weui-actionsheet__cell">
					<a href="<c:url value='/wechat/question/init'/>" target="_blank">勘查问卷</a>
				</div>
				<div class="weui-actionsheet__cell">
					<a href="<c:url value='/wechat/survey/siteSurvey/init'/>" target="_blank">开始勘查</a>
				</div>
			</div>
			<div class="weui-actionsheet__action">
				<div class="weui-actionsheet__cell" id="actionsheet_cancel" onclick="hideMenu('survey')">取消</div>
			</div>
		</div>
	</div>


	<div id="venue" style="display: none;">
		<div class="weui-mask_transparent actionsheet__mask actionsheet__mask_show"
			style="display: block; transform-origin: 0px 0px 0px; opacity: 1; transform: scale(1, 1);"></div>
		<div class="weui-actionsheet weui-actionsheet_toggle" id="weui-actionsheet">
			<div class="weui-actionsheet__menu">
				<div class="weui-actionsheet__cell">
					<a href="<c:url value='/wechat/venue/addVenue/init'/>" target="_blank">新增场馆</a>
				</div>
				<div class="weui-actionsheet__cell">
					<a href="<c:url value='/wechat/venue/venueList/init'/>" target="_blank">修改场馆</a>
				</div>
			</div>
			<div class="weui-actionsheet__action">
				<div class="weui-actionsheet__cell" id="actionsheet_cancel" onclick="hideMenu('venue')">取消</div>
			</div>
		</div>
	</div>

</body>
</html>