<%@ page contentType="text/html;charset=UTF-8"%>
<%@ page import="org.springframework.security.core.AuthenticationException"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE html>
<html>
<head>
<%@include file="/WEB-INF/views/include/head.jsp"%>
<link href="${ctxStatic }/css/plugins/bootstrap-table/bootstrap-table.min.css?v=${version}" rel="stylesheet">
</head>
<body class="gray-bg">
	<div class="wrapper wrapper-content animated fadeInRight">
		<div class="row">
			<div class="col-sm-12">
				<div class="ibox float-e-margins">
					<div class="ibox-content">
						<div class="btn-group hidden-xs" id="tableEventsToolbar" role="group">
							<a href="<c:url value='/manage/user/addUser/init'/>" target="dialog" width="960px" height="600px" class="btn btn-primary">
								<i class="glyphicon glyphicon-plus" aria-hidden="true"></i> 添加用户
							</a>
						</div>
						<table id="userTable">
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
	<%@include file="/WEB-INF/views/include/foot.jsp"%>
	<script src="${ctxStatic }/js/plugins/bootstrap-table/bootstrap-table.min.js?v=${version}"></script>
	<script src="${ctxStatic }/js/plugins/bootstrap-table/locale/bootstrap-table-zh-CN.min.js?v=${version}"></script>
	<script src="${ctxStatic }/js/tablePage.js?v=${version}"></script>
	<script>
		$(function(){
			var objId = "userTable";
			var url = ctx + "/manage/user/findUserListForPage.json";
			var columns = [  
					 {title: 'id',field: 'id', visible: false, align: 'center',valign: 'middle'},     
					 {title: '真实姓名',field: 'realName',align: 'center',valign: 'middle',sortable: true},   
					 {title: '账号',field: 'userName',align: 'center',valign: 'middle',sortable: true},  
					 {title: '手机',field: 'phone', align: 'center',valign: 'middle',sortable: true},  
					 {title: '邮箱',field: 'email',align: 'center',valign: 'middle',sortable: true},    
					 {title: '角色',field: 'userRoles',align: 'center',valign: 'middle',sortable: true},  
					 {title: '状态',field: 'active', align: 'center',valign: 'middle',sortable: true},  
					 {title: '创建时间',field: 'createOn',align: 'center',valign: 'middle',sortable: true},  
					 {title: '操作',field: '#',align: 'center',  
					     formatter:function(value,row,index){    
					         var e = '<a class="btn btn-primary" href="'+ctx+'/manage/user/editUser/'+row.id+'" target="dialog" width="960px" height="600px"><i class="fa fa-edit"></i>修改</a>';    
					         var d = "";
					         if(row.active =="有效"){
					       	  d = '<a class="ml-10 btn btn-primary" href="'+ctx+'/manage/user/freezeUser/'+row.id+'" target="ajaxTodo" title="确定冻结此用户？"><i class="fa fa-lock"></i>冻结</a>';
					         }else{
					       	  d = '<a class="ml-10 btn btn-primary" href="'+ctx+'/manage/user/activeUser/'+row.id+'" target="ajaxTodo" title="确定启用此用户？"><i class="fa fa-unlock"></i>启用</a>';
					         }
					         return e+d;    
					     }   
					 }  
					];
			bootstrapTableDiy(objId,url,columns);

			initLayerBtnClick();
		})
	</script>
</body>
</html>
