<%@ page contentType="text/html;charset=UTF-8" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
	<%@include file="/WEB-INF/views/include/head.jsp" %>
</head>
<%@ page isELIgnored="false"%>
<body>
<div class="pageContent" >
	<div class="row">
       <div class="col-sm-12">
           <div class="ibox float-e-margins">
               <div class="ibox-title">
                   <h5>勘查人员信息</h5>
               </div>
               <div class="ibox-content">
                   <form class="form-horizontal m-t" method="post" id="addUser" action="<c:url value='/manage/user/updateUser.json' />" class="pageForm required-validate" onsubmit="return validateCallback(this);">
                       <input type="hidden" name="oid" value="${user.oid }"/>
                       <div class="form-group">
                           <label class="col-sm-3 control-label">账号名：</label>
                           <div class="col-sm-8">
                              <input id="userName" name="userName" type="text" class="form-control" value="${user.userName }" readonly="readonly">
                           </div>
                       </div>
                       <div class="form-group">
                           <label class="col-sm-3 control-label">真实姓名：</label>
                           <div class="col-sm-8">
                              <input id="realName" name="realName" value="${user.realName }" minlength="2" type="text" class="form-control" required="" aria-required="true">
                           </div>
                       </div>
                       <div class="form-group">
                           <label class="col-sm-3 control-label">密码：</label>
                           <div class="col-sm-8">
                               <input id="password" name="password" value="" type="text" class="form-control" >
                           </div>
                       </div>
                       <div class="form-group">
                           <label class="col-sm-3 control-label">手机号：</label>
                           <div class="col-sm-8">
                               <input id="phone" name="phone" value="${user.phone }" minlength="2" type="text" class="form-control" required="" aria-required="true">
                           </div>
                       </div>
                       <div class="form-group">
                           <label class="col-sm-3 control-label">邮箱：</label>
                           <div class="col-sm-8">
                               <input id="email" name="email" value="${user.email }" minlength="2" type="text" class="form-control" required="" aria-required="true">
                           </div>
                       </div>
                       <div class="form-group">
                           <label class="col-sm-3 control-label">角色：</label>
                           <div class="col-sm-8">
                           		<input value="${user.roleList[0].name }" readonly="readonly" class="form-control">
                           </div>
                       </div>
                   </form>
               </div>
           </div>
       </div>
   </div>
</div>
<%@include file="/WEB-INF/views/include/foot.jsp" %>
<script type="text/javascript">
$('form').validate();
</script>
</body>
</html>
