package com.bcxin.survey.wechat.utils;

import java.util.ResourceBundle;

import javax.servlet.http.HttpServletRequest;

import com.bcxin.survey.wechat.utils.aes.AesException;
import com.bcxin.survey.wechat.utils.aes.WXBizMsgCrypt;


/**
 * 加密解密工具类
 * 
 * @author 百川信
 * @date 2014-11-24
 */
public class AuthProcess {
	
	private static ResourceBundle rb = ResourceBundle.getBundle("config");
	public final static String Token = rb.getString("token");// 公众平台上面自己填写的Token
	public final static String EncodingAESKey = rb.getString("EncodingAESKey");// 公众平台上面自己填写的43位EncodingAESKey
	public final static String AppID = rb.getString("appId");// 应用的appid

	/**
	 * 将加密后的原文进行解密重新封装
	 * 
	 * @param request
	 * @param originalXml 原xml
	 * @return 重新解密后的xml
	 */
	public static String decryptMsg(HttpServletRequest request,
			String originalXml) {
		// 微信加密签名
		// String sVerifyMsgSig = request.getParameter("signature");
		String msgSignature = request.getParameter("msg_signature");
		// 时间戳
		String timestamp = request.getParameter("timestamp");
		// 随机数
		String nonce = request.getParameter("nonce");
		try {
			WXBizMsgCrypt pc = new WXBizMsgCrypt(Token, EncodingAESKey, AppID);
			return pc.decryptMsg(msgSignature, timestamp, nonce, originalXml);
		} catch (AesException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 对需要回复的原文进行加密重新封装
	 * 
	 * @param request
	 * @param replyXml 需要回复的xml
	 * @return 重新加密后的xml
	 */
	public static String encryptMsg(HttpServletRequest request, String replyXml) {
		// 时间戳
		String timestamp = request.getParameter("timestamp");
		// 随机数
		String nonce = request.getParameter("nonce");
		try {
			WXBizMsgCrypt pc = new WXBizMsgCrypt(Token, EncodingAESKey, AppID);
			return pc.encryptMsg(replyXml, timestamp, nonce);
		} catch (AesException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}
}
