package com.bcxin.survey.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aspose.words.*;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.survey.Survey_FeedBack;
import com.bcxin.survey.domain.survey.Survey_Info;
import com.bcxin.survey.domain.survey.Survey_Photo;
import com.bcxin.survey.domain.survey.Survey_Questionnaire;
import com.bcxin.survey.dto.*;
import com.bcxin.survey.service.log.SysLogService;
import com.bcxin.survey.service.wechat.SurveyFeedBackService;
import com.bcxin.survey.service.wechat.SurveyInfoService;
import com.bcxin.survey.service.wechat.SurveyPhotoService;
import com.bcxin.survey.service.wechat.SurveyQuestionnaireService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author hzp
 * 生成勘查报告
 */
@Service("reportUtil")
@Transactional
@Slf4j
public class ReportUtil {

    private static Map<String,Integer> reportMap=new HashMap<>();

    @Autowired
    private SurveyQuestionnaireService questionnaireService;
    @Autowired
    private SurveyInfoService surveyInfoService;
    @Autowired
    private SurveyFeedBackService feedBackService;
    @Autowired
    private SurveyPhotoService surveyPhotoService;
    @Autowired
    private SysLogService sysLogService;

    @Value("${report_mail_cc}")
    private String report_mail_cc;

//    /**
//     * 获取容器
//     * @return
//     */
//    public static ReportUtil getBean(){
//        ReportUtil reportUtil=(ReportUtil)SpringContextUtil.getBean("reportUtil");
//        return reportUtil;
//    }

    /**
     * 根据勘查问卷id生成踏勘报告，并保存
     * @param questionnaireId
     * @return
     */
    public String createAndSaveSurveyReport(Long questionnaireId){
        Survey_Questionnaire questionnaire=questionnaireService.findQuestionnaireByOid(questionnaireId);
        String surveyReport= createSurveyReport1(questionnaire);
//        String surveyReport= createSurveyReport(questionnaire);
        questionnaire.setReportPath(surveyReport);
        questionnaireService.saveOrUpdate(questionnaire);
        return surveyReport;
    }

    public String createSurveyReport(Survey_Questionnaire questionnaire){
        FileOutputStream fileOS = null;
        InputStream license = null;
        InputStream word = null;
        String surveyReport="";
        try {
            long old = System.currentTimeMillis();

            // 1.组装勘查模板需要的数据
            List<QuestionAndAnswer> fillWordList=getFillData(questionnaire.getOid());

            System.out.println("========> createSurveyReport.步骤：1-------------");
            // 2.填充数据到word模板
            // 获取license
            license = ReportUtil.class.getClassLoader().getResourceAsStream("license.xml");
            System.out.println("========> createSurveyReport.步骤：2-------------");
            License aposeLic = new License();
            aposeLic.setLicense(license);
            word = ReportUtil.class.getClassLoader().getResourceAsStream("template/surveyReport.doc");
            System.out.println("========> createSurveyReport.步骤：3-------------");
            Document docAll = new Document(word);
            String[] questionFieldNames =new String[]{"question","answer"};
            System.out.println("========> createSurveyReport.步骤：4-------------");
            System.out.println("========> createSurveyReport.步骤：5-------------");
            Document doc;
            DocumentBuilder builder;
            for(QuestionAndAnswer entity : fillWordList){
                InputStream wordDetail = null;
                try {
                    wordDetail = ReportUtil.class.getClassLoader().getResourceAsStream("template/reportDetail.doc");
                    doc = new Document(wordDetail);
                    doc.getMailMerge().execute(questionFieldNames, new Object[]{entity.getQuestion(),entity.getAnswer()});

                    // 填充图片
                    builder = new DocumentBuilder(doc);
                    builder.moveToMergeField("img");
                    for(String photo : entity.getPhotoList()){
                        try {
                            //图片先完成3倍质量压缩再写入文件
                            photo = FileUtils.reduceQualityImg(photo);
                            builder.insertImage(photo, 150, 160);
                            builder.write("  ");
                        } catch (Exception e){
                            String content="图片插入失败，path="+photo+",questionnaireId="+questionnaire.getOid();
                            sysLogService.saveLog(this.getClass().getName()+".createSurveyReport",content,e);
                        }
                    }
                    doc.getFirstSection().getPageSetup().setSectionStart(SectionStart.CONTINUOUS);
                    docAll.appendDocument(doc, ImportFormatMode.KEEP_SOURCE_FORMATTING);
                } catch (Exception e) {
                    e.printStackTrace();
                    sysLogService.saveLog(this.getClass().getName()+".createSurveyReport",questionnaire.getOid()+"",e);
                    throw new RuntimeException(e);
                } finally {
                    try {
                        if (wordDetail != null) {
                            wordDetail.close();
                        }
                    } catch (IOException e){
                        e.printStackTrace();
                    }
                }
            }
            System.out.println("========> createSurveyReport.步骤：6-------------");

            // 3.生成word
            if(fillWordList!=null && fillWordList.size()>0){
                System.out.println("========> createSurveyReport.步骤：6.1-------------");
                // 获取勘查反馈
                Survey_FeedBack feedBack = feedBackService.findSurveyFeedBackByOid(questionnaire.getFeedBack().getOid());
                System.out.println("========> createSurveyReport.步骤：6.2-------------");
                User user = feedBack.getUser();
                String[] fieldNames=new String[]{"header","title","surveyStep","pageCount"};
                String title = questionnaire.getFeedBack().getSurveyTask().getName();
                title = title + "--"+questionnaire.getVenue().getName()+"";
                String surveyStep = questionnaire.getFeedBack().getSurveyStep().getName()+"报告";
                String header = title+surveyStep;
                // 获得页数
                int pageCount = docAll.getPageCount();
                Object[] values=new Object[]{header,title,surveyStep,pageCount};
                docAll.getMailMerge().execute(fieldNames, values);
                System.out.println("========> createSurveyReport.步骤：6.3-------------");

                // 导出文件
                String[] folderPath = new String[]{ConfigUtil.material(), cn.hutool.core.date.DateUtil.today()};
                String dir = FileUtils.appendFolderPath(folderPath);
                String fileName = FileUtils.packTimestamp(questionnaire.getOid()+"") + ".doc";
                String detailPath = dir + fileName;
                // 输出路径
                File file = new File(detailPath);
                fileOS = new FileOutputStream(file);
                docAll.save(fileOS, SaveFormat.DOC);
                System.out.println("========> createSurveyReport.步骤：6.4-------------");

                // 踏勘报告路径
                surveyReport=ConfigUtil.getValue("tk_url") + "getResourceFullPath.do?fullPath=" + detailPath;

                // 记录日志
                long now = System.currentTimeMillis();
                StringBuilder result=new StringBuilder();
                result.append("问卷id："+questionnaire.getOid()).append("\r\n");
                result.append("勘查报告路径："+surveyReport).append("\r\n");
                result.append("勘查报告保存路径："+file.getPath()).append("\r\n");
                result.append("耗时："+((now - old) / 1000.0) + "秒").append("\r\n");
                sysLogService.saveLog(this.getClass().getName()+".createSurveyReport",result.toString(),false);

                System.out.println("========> createSurveyReport.步骤：6.5-------------");
                // 发送邮件
                EmailUtil emailUtil = new EmailUtil();
                if(StringUtil.isEmpty(report_mail_cc)){
                    report_mail_cc = "takanbaogao@baichuanxin.com";
                }
                emailUtil.sendEmail(title+surveyStep, "尊敬的勘查人员"+user.getRealName()+":<br/>&nbsp;&nbsp;&nbsp;&nbsp;您好，附件是"+title+surveyStep+"，请查收!",user.getEmail() , file);
                emailUtil.sendEmail(title+surveyStep, "尊敬的勘查人员"+user.getRealName()+":<br/>&nbsp;&nbsp;&nbsp;&nbsp;您好，附件是"+title+surveyStep+"，请查收!",report_mail_cc , file);
                System.out.println("========> createSurveyReport.步骤：6.6-------------");
            }else{
                sysLogService.saveLog(this.getClass().getName()+".createSurveyReport","没有对应勘查信息，不能生成报告，问卷id："+questionnaire.getOid(),true);
            }
            System.out.println("========> createSurveyReport.步骤：7-------------");
            return surveyReport;
        } catch (Exception e) {
            e.printStackTrace();
            sysLogService.saveLog(this.getClass().getName()+".createSurveyReport",questionnaire.getOid()+"",e);
            throw new RuntimeException(e);
        } finally {
            try {
                if (fileOS != null) {
                    fileOS.close();
                }
                if (license != null) {
                    license.close();
                }
                if (word != null) {
                    word.close();
                }
            } catch (IOException e){
                e.printStackTrace();
            }
        }
    }

    public String createSurveyReport1(Survey_Questionnaire questionnaire){
        long old = System.currentTimeMillis();
        String title = questionnaire.getFeedBack().getSurveyTask().getName();
        title = title + "--"+questionnaire.getVenue().getName()+"";
        String surveyStep = questionnaire.getFeedBack().getSurveyStep().getName()+"报告";
        Document docAll = newDocument(questionnaire.getOid(),title,surveyStep);
        // 3.生成word
        if(docAll!=null){
            // 获取勘查反馈
            Survey_FeedBack feedBack = feedBackService.findSurveyFeedBackByOid(questionnaire.getFeedBack().getOid());
            return saveDoc(feedBack.getUser(),docAll,questionnaire.getOid(),old,title,surveyStep);
        }else{
            sysLogService.saveLog(this.getClass().getName()+".createSurveyReport","没有对应勘查信息，不能生成报告，问卷id："+questionnaire.getOid(),true);
        }
        return "";
    }

    public String saveDoc(User user,Document docAll,Long questionnaireId,Long old,String title,String surveyStep){
        ByteArrayOutputStream outputStream = null;
        InputStream inputStream = null;
        String surveyReport="";
        try {
            // 导出文件
            String[] folderPath = new String[]{ConfigUtil.material(), cn.hutool.core.date.DateUtil.today()};
            String dir = FileUtils.appendFolderPath(folderPath);
            outputStream = new ByteArrayOutputStream();
            docAll.save(outputStream, SaveFormat.DOC);
            inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            System.out.println("========> saveDoc.步骤：3-------------");
            // 踏勘报告路径
            surveyReport=FileUtils.huaweiOBSFileUpload(inputStream,dir,"doc");
            System.out.println("========> saveDoc.步骤：3,param:"+surveyReport+"-------------");
            // 记录日志
            long now = System.currentTimeMillis();
            StringBuilder result=new StringBuilder();
            result.append("问卷id："+questionnaireId).append("\r\n");
            result.append("勘查报告路径："+surveyReport).append("\r\n");
            result.append("耗时："+((now - old) / 1000.0) + "秒").append("\r\n");
            sysLogService.saveLog(this.getClass().getName()+".createSurveyReport",result.toString(),false);

            System.out.println("========> saveDoc.步骤：4-------------");
            // 发送邮件
            EmailUtil emailUtil = new EmailUtil();
            if(StringUtil.isEmpty(report_mail_cc)){
                report_mail_cc = "takanbaogao@baichuanxin.com";
            }
            emailUtil.sendEmail(title+surveyStep, "尊敬的勘查人员"+user.getRealName()+":<br/>&nbsp;&nbsp;&nbsp;&nbsp;您好，报告下载地址："+surveyReport+"，请查收!",user.getEmail() , null);
            emailUtil.sendEmail(title+surveyStep, "尊敬的勘查人员"+user.getRealName()+":<br/>&nbsp;&nbsp;&nbsp;&nbsp;您好，报告下载地址："+surveyReport+"，请查收!",report_mail_cc , null);

            return surveyReport;
        } catch (Exception e) {
            e.printStackTrace();
            sysLogService.saveLog(this.getClass().getName()+".createSurveyReport",questionnaireId+"",e);
            throw new RuntimeException(e);
        } finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            } catch (IOException e){
                e.printStackTrace();
            }
        }
    }

    private Document newDocument(Long questionnaireId,String title,String surveyStep){
        // 1.组装勘查模板需要的数据
        List<QuestionAndAnswer> fillWordList = getFillData(questionnaireId);
        if(fillWordList.size()==0){
            return null;
        }
        InputStream license = null;
        InputStream word = null;
        try {
            // 2.填充数据到word模板
            // 获取license
            license = ReportUtil.class.getClassLoader().getResourceAsStream("license.xml");
            License aposeLic = new License();
            aposeLic.setLicense(license);
            word = ReportUtil.class.getClassLoader().getResourceAsStream("template/surveyReport.doc");
            Document docAll = new Document(word);
            String[] questionFieldNames =new String[]{"question","answer"};

            Document doc;
            DocumentBuilder builder;
            for(QuestionAndAnswer entity : fillWordList){
                InputStream wordDetail= null;
                try {
                    wordDetail = ReportUtil.class.getClassLoader().getResourceAsStream("template/reportDetail.doc");
                    doc = new Document(wordDetail);
                    doc.getMailMerge().execute(questionFieldNames, new Object[]{entity.getQuestion(),entity.getAnswer()});

                    // 填充图片
                    builder = new DocumentBuilder(doc);
                    builder.moveToMergeField("img");
                    for(String photo : entity.getPhotoList()){
                        try {
                            //图片先完成3倍质量压缩再写入文件
                            photo = FileUtils.reduceQualityImg(photo);
                            builder.insertImage(photo, 150, 160);
                            builder.write("  ");
                        } catch (Exception e){
                            String content="图片插入失败，path="+photo+",questionnaireId="+questionnaireId;
                            sysLogService.saveLog(this.getClass().getName()+".newDocument",content,e);
                        }
                    }
                    doc.getFirstSection().getPageSetup().setSectionStart(SectionStart.CONTINUOUS);
                    docAll.appendDocument(doc, ImportFormatMode.KEEP_SOURCE_FORMATTING);
                } catch (Exception e) {
                    e.printStackTrace();
                    sysLogService.saveLog(this.getClass().getName()+".newDocument",questionnaireId+"",e);
                    throw new RuntimeException(e);
                } finally {
                    try {
                        if (wordDetail != null) {
                            wordDetail.close();
                        }
                    } catch (IOException e){
                        e.printStackTrace();
                    }
                }
            }

            String[] fieldNames=new String[]{"header","title","surveyStep","pageCount"};
            // 获得页数
            int pageCount = docAll.getPageCount();
            Object[] values=new Object[]{title+surveyStep,title,surveyStep,pageCount};
            docAll.getMailMerge().execute(fieldNames, values);
            return docAll;

        } catch (Exception e) {
            e.printStackTrace();
            sysLogService.saveLog(this.getClass().getName()+".newDocument",questionnaireId+"",e);
            throw new RuntimeException(e);
        } finally {
            try {
                if (license != null) {
                    license.close();
                }
                if (word != null) {
                    word.close();
                }
            } catch (IOException e){
                e.printStackTrace();
            }
        }
    }


    /**
     * 获取填充数据
     * @return
     */
    private List<QuestionAndAnswer> getFillData(Long questionnaireId){
        int questionIndex =1;
        List<QuestionAndAnswer> fillWordList=new ArrayList<>();

        // 获取勘查问卷详情
        List<Survey_Info> surveyInfoList = surveyInfoService.findSurveyInfoListByQuestionnaireId(questionnaireId);
//        List<SurveyInfoDto> surveyInfoList = surveyInfoService.findSurveyInfoDtoListByQuestionnaireId(questionnaireId);
        List<String> photoList;
        // 组装勘查模板需要的数据
        for(Survey_Info info:surveyInfoList){
//            String question = questionIndex +"."+ info.getQuestion();
//            String answer = info.getAnswer();
            photoList=new ArrayList<>();
            // 有回答的才需要填充
            if(StringUtil.isNotEmpty(info.getAnswer())) {
                for (Survey_Photo photo : info.getPhotos()) {
                    photoList.add(photo.getPath());
                }
//                photoList=surveyPhotoService.findPhotoListByInfoId(info.getOid());
                System.out.println("========> getFillData.问题："+questionIndex +"."+ info.getQuestion()+":"+info.getAnswer()+"，size："+photoList.size()+"-------------");
                fillWordList.add(new QuestionAndAnswer(questionIndex +"."+ info.getQuestion(), info.getAnswer(), photoList));
            }
            questionIndex++;
        }
        return fillWordList;
    }


//    public static class QuestionAndAnswer{
//        /**
//         * 问题
//         */
//        private String question;
//        /**
//         * 回答
//         */
//        private String answer;
//        /**
//         * 图片
//         */
//        private List<String> photoList;
//
//        public String getQuestion() {
//            return question;
//        }
//
//        public void setQuestion(String question) {
//            this.question = question;
//        }
//
//        public String getAnswer() {
//            return answer;
//        }
//
//        public void setAnswer(String answer) {
//            this.answer = answer;
//        }
//
//        public List<String> getPhotoList() {
//            return photoList;
//        }
//
//        public void setPhotoList(List<String> photoList) {
//            this.photoList = photoList;
//        }
//
//        public QuestionAndAnswer(String question,String answer,List<String> photoList){
//            this.question=question;
//            this.answer=answer;
//            this.photoList=photoList;
//        }
//    }

    public String createSurveyReportTest(BuildTestDto dto){
        System.out.println("=====>       createSurveyReportTest,dto:"+JSON.toJSONString(dto));
        String oid = dto.getOid();
        String taskName = dto.getTaskName();
        String venueName = dto.getVenueName();
        String surveyStep = dto.getSurveyStep();
        String answers =JSON.toJSONString(dto.getAnswers());
        FileOutputStream fileOS = null;
        InputStream license = null;
        InputStream word = null;
        String surveyReport="";
        try {
            // 2.填充数据到word模板
            // 获取license
            license = ReportUtil.class.getClassLoader().getResourceAsStream("license.xml");
            License aposeLic = new License();
            aposeLic.setLicense(license);
            word = ReportUtil.class.getClassLoader().getResourceAsStream("template/surveyReport.doc");
            Document docAll = new Document(word);
//            String[] questionFieldNames =new String[]{"question","answer"};
//            Document doc;
//            DocumentBuilder builder;
            List<Document> docs = new ArrayList<>();
            for(CustomObject entity : dto.getAnswers()){
                new Thread(()->{
                    syncAssDoc(entity,docs,dto.getOid());
                }).start();
                /*InputStream wordDetail = null;
                try {
                    wordDetail = ReportUtil.class.getClassLoader().getResourceAsStream("template/reportDetail.doc");
                    doc = new Document(wordDetail);
                    doc.getMailMerge().execute(questionFieldNames, new Object[]{entity.getQuestion(),entity.getAnswer()});

                    // 填充图片
                    builder = new DocumentBuilder(doc);
                    builder.moveToMergeField("img");
                    for(FileObject photo : entity.getFileObjects()){
                        try {
                            //图片先完成3倍质量压缩再写入文件
                            String url = FileUtils.reduceQualityImg(photo.getUrl());
                            builder.insertImage(url, 150, 160);
                            builder.write("  ");
                        } catch (Exception e){
                            e.printStackTrace();
                        }
                    }
                    doc.getFirstSection().getPageSetup().setSectionStart(SectionStart.CONTINUOUS);
                    docAll.appendDocument(doc, ImportFormatMode.KEEP_SOURCE_FORMATTING);
                } catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                } finally {
                    try {
                        if (wordDetail != null) {
                            wordDetail.close();
                        }
                    } catch (IOException e){
                        e.printStackTrace();
                    }
                }*/
            }
            for (int i = 0; i < 70; i++) {
                Thread.sleep(2000);
                Integer num = reportMap.get(oid);
                if(num==0){
                    log.info("=======>     createSurveyReportTest.doc:跑完了");
                    break;
                }
            }
            for (Document doc: docs) {
                docAll.appendDocument(doc, ImportFormatMode.KEEP_SOURCE_FORMATTING);
            }
            log.info("=======>     createSurveyReportTest.docAll:写入文档了");
            // 3.生成word
            if(dto.getAnswers()!=null && dto.getAnswers().size()>0){
                // 获取勘查反馈
                String[] fieldNames=new String[]{"header","title","surveyStep","pageCount"};
                String title = taskName;
                title = title + "--"+venueName+"";
                surveyStep = surveyStep+"报告";
                String header = title+surveyStep;
                // 获得页数
                int pageCount = docAll.getPageCount();
                Object[] values=new Object[]{header,title,surveyStep,pageCount};
                docAll.getMailMerge().execute(fieldNames, values);

                // 导出文件
                String[] folderPath = new String[]{ConfigUtil.material(), cn.hutool.core.date.DateUtil.today()};
                String dir = FileUtils.appendFolderPath(folderPath);
                String fileName = FileUtils.packTimestamp(oid) + ".doc";
                String detailPath = dir + fileName;
                // 输出路径
                File file = new File(detailPath);
                fileOS = new FileOutputStream(file);
                docAll.save(fileOS, SaveFormat.DOC);

                // 踏勘报告路径
                surveyReport=ConfigUtil.getValue("tk_url") + "getResourceFullPath.do?fullPath=" + detailPath;
            }
            return surveyReport;
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        } finally {
            try {
                if (fileOS != null) {
                    fileOS.close();
                }
                if (license != null) {
                    license.close();
                }
                if (word != null) {
                    word.close();
                }
            } catch (IOException e){
                e.printStackTrace();
            }
        }
    }

    private void syncAssDoc(CustomObject entity,List<Document> docs,String oid){
        changeNum(oid,1,0);
        String[] questionFieldNames =new String[]{"question","answer"};
        Document doc;
        DocumentBuilder builder;
        try(InputStream wordDetail = ReportUtil.class.getClassLoader().getResourceAsStream("template/reportDetail.doc");) {
            doc = new Document(wordDetail);
            doc.getMailMerge().execute(questionFieldNames, new Object[]{entity.getQuestion(),entity.getAnswer()});

            // 填充图片
            builder = new DocumentBuilder(doc);
            builder.moveToMergeField("img");
            for(FileObject photo : entity.getFileObjects()){
                try {
                    //图片先完成3倍质量压缩再写入文件
                    String url = FileUtils.reduceQualityImg(photo.getUrl());
                    builder.insertImage(url, 150, 160);
                    builder.write("  ");
                } catch (Exception e){
                    e.printStackTrace();
                }
            }
            doc.getFirstSection().getPageSetup().setSectionStart(SectionStart.CONTINUOUS);
            docs.add(doc);
//            docAll.appendDocument(doc, ImportFormatMode.KEEP_SOURCE_FORMATTING);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }finally {
            changeNum(oid,1,1);
        }
    }

    private synchronized void changeNum(String key,int cnum,int type){
        Integer num = reportMap.get(key);
        if(type==0){
            if(num==null){
                reportMap.put(key,cnum);
            }else{
                reportMap.put(key,num+cnum);
            }
        }else{
            reportMap.put(key,num-cnum);
        }
    }
}
