package com.bcxin.survey.utils;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;

import javax.imageio.ImageIO;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;



public class ErweimaUtil {

	 private static final int BLACK = 0xFF000000; 
	   private static final int WHITE = 0xFFFFFFFF; 
	    
	   private ErweimaUtil() {} 
	    
	      
	   public static BufferedImage toBufferedImage(BitMatrix matrix) { 
	     int width = matrix.getWidth(); 
	     int height = matrix.getHeight(); 
	     BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB); 
	     for (int x = 0; x < width; x++) { 
	       for (int y = 0; y < height; y++) { 
	         image.setRGB(x, y, matrix.get(x, y) ? BLACK : WHITE); 
	       } 
	     } 
	     return image; 
	   } 
	    
	      
	   public static void writeToFile(BitMatrix matrix, String format, File file) 
	       throws IOException { 
	     BufferedImage image = toBufferedImage(matrix); 
	     if (!ImageIO.write(image, format, file)) { 
	       throw new IOException("Could not write an image of format " + format + " to " + file); 
	     } 
	   } 
	    
	      
	   public static void writeToStream(BitMatrix matrix, String format, OutputStream stream) 
	       throws IOException { 
	     BufferedImage image = toBufferedImage(matrix); 
	     if (!ImageIO.write(image, format, stream)) { 
	       throw new IOException("Could not write an image of format " + format); 
	     } 
	   } 
	   
	 /**
	 * 生成要访问的链接 和 图片生成的地址
	 * @param url
	 * @param path
	 * @throws Exception 
	 */ 
	public static void createErWeiMa(String url,String  path) throws Exception{
		    //测试url
		    url="http://test.pss360.cn/getOrederDetatil/50757632";
		    //http://localhost:8080/risk/getOrederDetatil/cJsY/8vZ/vIT5zN5KjljDw==
		    String oid=url.substring(url.lastIndexOf('/')+1,url.length());
		    String oidStr =DesUtil.desEncodeCBC(Const.REPORT_KEY, oid);
		    url=url.substring(0, url.lastIndexOf('/'));
		    url+="?sec="+oidStr;
		    System.out.println(url);
		    int width = 300; 
	        int height = 300; 
	        //二维码的图片格式 
	        String format = "jpg"; 
	        Hashtable hints = new Hashtable(); 
	        //内容所使用编码 
	        hints.put(EncodeHintType.CHARACTER_SET, "utf-8"); 
	        BitMatrix bitMatrix = new MultiFormatWriter().encode(url, 
	                BarcodeFormat.QR_CODE, width, height, hints); 
	        //生成二维码 
	        File outputFile = new File(path); 
	        ErweimaUtil.writeToFile(bitMatrix, format, outputFile); 
	   }
	   
	   public static void main(String[] args) throws Exception { 
		   createErWeiMa(null,"d:"+File.separator+"news.jpg");
	    } 
}
