package com.bcxin.survey.utils;

/**
 * 
 * <b>字典常量字段库 </b>
 * 
 * @author  xiangyaoqi
 * @date 2017年05月02日
 * @注意事项 </b>
 * <b>
 */
public final class DictConst {

	private DictConst(){} //空的构造函数，避免实例化该类

	/**
	 * 基础的，是和否
	 */
	public final static String Y = "1";
	public final static String N = "0";


	/**
	 * 码表基本信息
	 */

    /* 交易产生对象 TRANSACTIONOBJECT */
	public final static String ACTIVITYSTATUS_SQZ = "10";    //活动状态_申请中
	public final static String ACTIVITYSTATUS_SPZ = "20";    //活动状态_审批中
	public final static String ACTIVITYSTATUS_CBZ = "30";    //活动状态_筹备中
	public final static String ACTIVITYSTATUS_jXZ = "40";    //活动状态_进行中
	public final static String ACTIVITYSTATUS_HDJS = "50";    //活动状态_结束

	/* 材料类型 ACTIVITYMATERIALTYPE */
	public final static String ACTIVITYMATERIALTYPE_PGBG = "1";    //材料类型_评估报告
	public final static String ACTIVITYMATERIALTYPE_DZBD = "2";    //材料类型_电子保单
	public final static String ACTIVITYMATERIALTYPE_JLBG_KS = "3";   //材料类型_监理报告（活动开始前）
	public final static String ACTIVITYMATERIALTYPE_JLBG_JS = "10";  //材料类型_监理报告（活动结束后）
	public final static String ACTIVITYMATERIALTYPE_DYJDTKBG = "4";    //材料类型_第一阶段勘查报告
	public final static String ACTIVITYMATERIALTYPE_DEJDTKBG = "5";    //材料类型_第二阶段勘查报告
	public final static String ACTIVITYMATERIALTYPE_DSJDTKBG = "6";    //材料类型_第三阶段勘查报告
	public final static String ACTIVITYMATERIALTYPE_PGCL = "7";    //材料类型_评估材料
	public final static String ACTIVITYMATERIALTYPE_BPCL = "8";    //材料类型_报批材料
	public final static String ACTIVITYMATERIALTYPE_SPXKS = "9";    //材料类型_审批许可书

	/* 交易产生对象 TRANSACTIONOBJECT */
	public final static String TRANSACTIONOBJECT_FXBG = "1";    //交易产生对象_风险报告
	public final static String TRANSACTIONOBJECT_BX = "2";    //交易产生对象_保险

	/* 支付方式  PAYMENTMODE */
//	public final static String PAYMENTMODE_XSZF = "1";    //支付方式_线上支付
//	public final static String PAYMENTMODE_XXZF = "2";    //支付方式_线下支付

	/* 线上支付类型 PAYMENTTYP */
	public final static String PAYMENTTYPE_XXZF = "1";    //支付方式_线下支付
	public final static String PAYMENTTYPE_ZFB = "2";    //线上支付类型_支付宝
	public final static String PAYMENTTYPE_YL = "3";    //线上支付类型_银联

	/* 报告状态 RRPORTSTATUS */
	public final static String RRPORTSTATUS_ZLSJ = "1";    //报告状态_资料收集
	public final static String RRPORTSTATUS_ZXZ = "2";    //报告状态_撰写中
	public final static String RRPORTSTATUS_YTJ = "3";    //报告状态_已提交

	/* 机构类型 ORGTYPE */
	public final static String ORGTYPE_CBDW = "1";    //机构类型_承办单位
	public final static String ORGTYPE_ZJJG = "2";    //机构类型_专家机构
	public final static String ORGTYPE_GAJG = "3";    //机构类型_公安机构
	public final static String ORGTYPE_GLJG = "4";    //机构类型_管理机构
	public final static String ORGTYPE_DSFFWJG = "5";    //机构类型_第三方服务机构

	/* 系统日志类型 LOGTYPE */
	public final static String LOGTYPE_XTYC = "1";    //系统日志类型_系统异常
	public final static String LOGTYPE_DSRW = "2";    //系统日志类型_定时任务

	/* 新闻类型 NEWSTYPE */
	public final static String NEWSTYPE_GGTZ = "0";            //新闻类型_公告通知
	public final static String NEWSTYPE_HYZX = "1";            //新闻类型_行业资讯
	public final static String NEWSTYPE_HDXX = "2";            //新闻类型_活动信息
	public final static String NEWSTYPE_ZCFL = "3";            //新闻类型_政策法律

	/* 用户类型 USERTYPE */
	public final static String USERTYPE_CBDWYH = "1";    //用户类型_承办单位用户
	public final static String USERTYPE_ZJJGYH = "2";    //用户类型_专家机构用户
	public final static String USERTYPE_GAJGYH = "3";    //用户类型_公安机构用户
	public final static String USERTYPE_GLJGYH = "4";    //用户类型_管理机构用户
	public final static String USERTYPE_GLJGYH_CW = "6";    //用户类型_管理机构用户_出纳
	public final static String USERTYPE_DSFFWJGYH = "5";    //用户类型_第三方服务机构用户
	public final static String USERTYPE_DSFFWJGYH_JS = "7";    //用户类型_风险评估机构用户_结算人员
	public final static String USERTYPE_DSFFWJGYH_ZG = "8";    //用户类型_风险评估机构用户_主管
	public final static String USERTYPE_DSFFWJGYH_ZXZY = "9";    //用户类型_自营服务机构用户_撰写单位_撰写专员
	public final static String USERTYPE_DSFFWJGYH_YSZY = "10";    //用户类型_自营服务机构用户_撰写单位_一审专员
	public final static String USERTYPE_DSFFWJGYH_FHRY = "11";    //用户类型_自营服务机构用户_撰写单位_复核人员
	public final static String USERTYPE_DSFFWJGYH_XZRY = "13";    //用户类型_自营服务机构用户_撰写单位_行政人员
	public final static String USERTYPE_DSFFWJGYH_TKQT= "14";    //用户类型_自营服务机构用户_勘查相关人员
	public final static String USERTYPE_DSFFWJGYH_TKJL= "18";    //用户类型_自营服务机构用户_勘查经理
	public final static String USERTYPE_JBMJ = "12";    //用户类型_经办民警
	public final static String USERTYPE_ZJGLY = "15";    //用户类型_专家管理员
	public final static String USERTYPE_GOV = "20";    //用户类型_承办单位政府用户

	public final static String USERTYPE_DSFFWJGYH_ZXZJ="16"; //用户类型_第三方服务机构用户_撰写专家
	public final static String USERTYPE_DSFFWJGYH_TKZJ="17"; //用户类型_第三方服务机构用户_勘查专家
	public final static String USERTYPE_DSFFWJGYH_TKXMJL= "18";    //用户类型_自营服务机构用户_勘查经理
	public final static String USERTYPE_DSFFWJGYH_TKQYJL= "19";    //用户类型_自营服务机构用户_勘查区域经理

	/* 服务机构类型 SERVICEORGTYPE */
	public final static String SERVICEORGTYPE_FXPGJG = "1";    //服务机构类型_风险评估机构
	public final static String SERVICEORGTYPE_CYGS = "2";    //服务机构类型_餐饮公司
	public final static String SERVICEORGTYPE_FBGS = "3";    //服务机构类型_防爆公司
	public final static String SERVICEORGTYPE_PWGS = "4";    //服务机构类型_票务公司
	public final static String SERVICEORGTYPE_BAGS = "5";    //服务机构类型_保安公司
	public final static String SERVICEORGTYPE_CZGS = "6";    //服务机构类型_场租公司
	public final static String SERVICEORGTYPE_LJGS = "7";    //服务机构类型_临建公司
	public final static String SERVICEORGTYPE_AJMGS = "8";    //服务机构类型_安检门公司
	public final static String SERVICEORGTYPE_JLGS = "9";    //服务机构类型_监理公司

	/* 服务模式 serviceMode */
	public final static String SERVICEMODE_ZY = "1";    //服务模式_自营
	public final static String SERVICEMODE_DSF = "2";    //服务模式_第三方

	/* 活动类型 ACTIVITYTYPE */
	public final static String ACTIVITYTYPE_TYBSHD = "100001";    //活动类型_体育比赛活动
	public final static String ACTIVITYTYPE_WYYCHD = "100002";    //活动类型_文艺演出活动
	public final static String ACTIVITYTYPE_ZLZXDHD = "100003";    //活动类型_展览展销等活动
	public final static String ACTIVITYTYPE_YYDHHD = "100004";    //活动类型_游园灯会活动
	public final static String ACTIVITYTYPE_ZPHHD = "100005";        //活动类型_招聘会活动
	public final static String ACTIVITYTYPE_GYCSHD = "100006";    //活动类型_公益慈善活动
	public final static String ACTIVITYTYPE_QT = "100007";        //活动类型_其他

	/* 场地类型 ADDRESSTYPE */
	public final static String ADDRESSTYPE_SN = "1";            //全封闭（室内）
	public final static String ADDRESSTYPE_SNLT = "2";            //半封闭（室内露天）
	public final static String ADDRESSTYPE_SW = "3";            //开放式（室外）
	public final static String ADDRESSTYPE_SNSW = "4";        //室内+室外
	public final static String ADDRESSTYPE_QT = "5";        //其他

	/* 审核状态 APPROVALSTATUS */
	public final static String APPROVALSTATUS_DSH = "1";    //审核状态_待审核
	public final static String APPROVALSTATUS_SHTG = "2";    //审核状态_审核通过
	public final static String APPROVALSTATUS_SHBTG = "3";    //审核状态_审核不通过

	/* 新闻来源 CATEGORYNEWS */
	public final static String CATEGORYNEWS_ZJZX = "0";    //新闻来源_中金在线
	public final static String CATEGORYNEWS_SJJJBD = "1";    //新闻来源_21世纪经济报道
	public final static String CATEGORYNEWS_ZJSBW = "2";    //新闻来源_证券时报网
	public final static String CATEGORYNEWS_MRJJXW = "3";    //新闻来源_每日经济新闻
	public final static String CATEGORYNEWS_GJJRB = "4";    //新闻来源_国际金融报
	public final static String CATEGORYNEWS_SHJRB = "5";    //新闻来源_上海金融报
	public final static String CATEGORYNEWS_DYCJRB = "6";    //新闻来源_第一财经日报
	public final static String CATEGORYNEWS_BJSB = "7";    //新闻来源_北京商报
	public final static String CATEGORYNEWS_ZGXWW = "8";    //新闻来源_中国新闻网
	public final static String CATEGORYNEWS_LCZB = "9";    //新闻来源_理财周报
	public final static String CATEGORYNEWS_JRSB = "10";    //新闻来源_金融时报
	public final static String CATEGORYNEWS_JRTZB = "11";    //新闻来源_金融投资报
	public final static String CATEGORYNEWS_SHZJB = "12";    //新闻来源_上海证券报
	public final static String CATEGORYNEWS_TZSB = "13";    //新闻来源_投资时报
	public final static String CATEGORYNEWS_TZZB = "14";    //新闻来源_投资者报
	public final static String CATEGORYNEWS_JJCKB = "15";    //新闻来源_经济参考报
	public final static String CATEGORYNEWS_ZHGSSB = "16";    //新闻来源_中华工商时报
	public final static String CATEGORYNEWS_HXW = "17";    //新闻来源_和讯网
	public final static String CATEGORYNEWS_XJRGC = "18";    //新闻来源_新金融观察
	public final static String CATEGORYNEWS_JZRB = "19";    //新闻来源_证券日报
	public final static String CATEGORYNEWS_ZGZJB = "20";    //新闻来源_中国证券报
	public final static String CATEGORYNEWS_DYW_GZRB = "21";    //新闻来源_大洋网-广州日报
	public final static String CATEGORYNEWS_ZGBXB = "22";    //新闻来源_中国保险报
	public final static String CATEGORYNEWS_QT = "23";    //新闻来源_其他

	/* 快递类型 EXPRESS */
	public final static String EXPRESS_SFKD = "1";    //快递类型_顺丰快递  EXPRESS
	public final static String EXPRESS_YTKD = "5";    //快递类型_圆通快递
	public final static String EXPRESS_STKD = "10";    //快递类型_申通快递
	public final static String EXPRESS_YDKD = "15";    //快递类型_韵达快递
	public final static String EXPRESS_ZTKD = "20";    //快递类型_中通快递
	public final static String EXPRESS_TTKD = "25";    //快递类型_天天快递
	public final static String EXPRESS_HTKD = "30";    //快递类型_汇通快递
	public final static String EXPRESS_LB = "35";    //快递类型_联邦
	public final static String EXPRESS_ZJS = "40";    //快递类型_宅急送
	public final static String EXPRESS_EMS = "45";    //快递类型_EMS

	/* 审核结果 APPROVEACTIVE */
	public final static String APPROVEACTIVE_SHZ = "0";    //审核结果_审核中
	public final static String APPROVEACTIVE_SHCG = "1";    //审核结果_审核成功
	public final static String APPROVEACTIVE_SHWTG = "2";    //审核结果_审核未通过

	/* 支付状态 PAYSTATUS */
	public final static String PAYSTATUS_WZF = "0";    //支付状态_未支付
	public final static String PAYSTATUS_YZF = "1";    //支付状态_已支付
	public final static String PAYSTATUS_ZFSB = "2";    //支付状态_支付失败
	public final static String PAYSTATUS_ZFGB = "3";    //支付状态_支付关闭

	/* 阅读状态 READSTATUS */
	public final static String READSTATUS_WD = "0";    //阅读状态_未读
	public final static String READSTATUS_YD = "1";    //阅读状态_已读

	/* 订单状态 ORDERSTATUS */
	public final static String ORDERSTATUS_WZF = "0"; //订单状态_未支付
	public final static String ORDERSTATUS_YZX = "1";	 //订单状态_已支付
	public final static String ORDERSTATUS_YQX = "2";	 //订单状态_已取消
	public final static String ORDERSTATUS_DWS = "3";	 //待完善


	/* 活动状态阶段 ACTIVITYSUBSTEP */
	public final static String ACTIVITYSUBSTEP_CGCJXM = "10";    //活动状态阶段_成功创建了项目
	public final static String ACTIVITYSUBSTEP_CGZFLYF = "15";    //活动状态阶段_成功支付了费用
	public final static String ACTIVITYSUBSTEP_CGTJLCL = "20";    //活动状态阶段_成功提交了材料
	public final static String ACTIVITYSUBSTEP_DYJDTKYWC = "25";    //活动状态阶段_第一阶段勘查已完成
	public final static String ACTIVITYSUBSTEP_FXPGBGYWC = "30";    //活动状态阶段_风险评估报告已完成
	public final static String ACTIVITYSUBSTEP_HDSPBTG = "35";    //活动状态阶段_活动审批不通过
	public final static String ACTIVITYSUBSTEP_HDSPTG = "40";    //活动状态阶段_活动审批通过
	public final static String ACTIVITYSUBSTEP_DRJDTKYWC = "45";    //活动状态阶段_第二阶段勘查已完成
	public final static String ACTIVITYSUBSTEP_JLBGYWC = "50";    //活动状态阶段_监理报告已完成
	public final static String ACTIVITYSUBSTEP_DSJDTKYWC = "55";    //活动状态阶段_第三阶段勘查已完成
	public final static String ACTIVITYSUBSTEP_XMJS = "60";    //活动状态阶段_项目结束

	/* 户外场地类型 OUTDOORTYPE */
	public final static String OUTDOORTYPE_XXGC = "1";        //户外场地类型_学校体育场，校内广场
	public final static String OUTDOORTYPE_GYGC = "2";       //户外场地类型_公园，文化广场
	public final static String OUTDOORTYPE_SYQGC = "3";        //户外场地类型_商业区广场
	public final static String OUTDOORTYPE_HBSD = "4";        //户外场地类型_海边沙滩，山地，水上，
	public final static String OUTDOORTYPE_QT = "5";          //户外场地类型_其他


	/*勘查阶段*/
	public final static String SURVEYSTEP_FIRST = "1"; //第一阶段勘查
	public final static String SURVEYSTEP_SECOND = "2"; //第二阶段勘查
	public final static String SURVEYSTEP_THIRD = "3"; //第三阶段勘查

	/**
	 * 题目类型，固定+开放
	 */
	public final static String QUESTIONTYPE_FIX = "1"; //固定
	public final static String QUESTIONTYPE_OPEN = "2"; //开放


	/** 任务接受状态**/
	public final static String ACCEPTSTATUS_NON = "0"; //未接收
	public final static String ACCEPTSTATUS_YES = "1"; //已接收
	public final static String ACCEPTSTATUS_TRANSFER = "2"; //申请转交

	/** 任务接受状态**/
	public final static String TASKSTATUS_NON = "1"; //未完成
	public final static String TASKSTATUS_CONTINUE = "2"; //进行中
	public final static String TASKSTATUS_COMPLETE = "3"; //已完成
	public final static String TASKSTATUS_CLOSE = "4"; //任务关闭
	public final static String TASKSTATUS_ASSIGNED = "5"; //已分配

	/** 勘查角色代码 **/
	public final static String USERROLE_PM = "tkxmjl"; //勘查项目经理
	public final static String USERROLE_CM = "tkry"; //勘查人员
	public final static String USERROLE_EXPERT = "tkzj"; //勘查专家

	public final static String USERTYPE_ZG = "8"; //主管类型
	public final static String USERTYPE_PM = "18"; //勘查项目经理
	public final static String USERTYPE_CM = "14"; //勘查人员
	public final static String USERTYPE_EXPERT = "17"; //勘查专家

	/* 同步类型 */
	public final static String SYNCTASKTYPE_TKBG = "T2";    //勘查报告
	public final static String SYNCTASKTYPE_ACTID = "T3";    //获得子站的活动id
	public final static String SYNCTASKTYPE_FILE = "99";	 //文件

	/* 生成材料 */
	public final static String MATERIALTASK_TKXQ = "T1";/* 踏勘详情 */
	public final static String MATERIALTASK_TKBG = "T2";/* 踏勘报告 */

	/**
	 * 专家来源：公有和私有
	 */
	public final static String EXPERT_SOURCE_PUBLIC="public";
	public final static String EXPERT_SOURCE_PRIVATE="private";

	/**
	 * 华为云短信模板
	 */
	public final static String SMSCODE_P01 = "P01";
	public final static String SMSCODE_B01 = "B01";
	public final static String SMSCODE_B02 = "B02";
	public final static String SMSCODE_B03 = "B03";
	public final static String SMSCODE_B04 = "B04";
	public final static String SMSCODE_B05 = "B05";
	public final static String SMSCODE_B06 = "B06";
	public final static String SMSCODE_B07 = "B07";
	public final static String SMSCODE_B08 = "B08";
	public final static String SMSCODE_B09 = "B09";
	public final static String SMSCODE_B10 = "B10";
	public final static String SMSCODE_B11 = "B11";
	public final static String SMSCODE_B12 = "B12";

}