package com.bcxin.survey.utils;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CommonUtil {

	/**
	 * 汉字转拼音
	 * 
	 * @param str
	 * @return
	 */
	public static String toPinYin(String str) {
		String py = "";
		String[] t = new String[str.length()];

		char[] hanzi = new char[str.length()];
		for (int i = 0; i < str.length(); i++) {
			hanzi[i] = str.charAt(i);
		}

		net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat t1 = new HanyuPinyinOutputFormat();
		t1.setCaseType(HanyuPinyinCaseType.LOWERCASE);
		t1.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
		t1.setVCharType(HanyuPinyinVCharType.WITH_V);

		try {
			for (int i = 0; i < str.length(); i++) {
				if ((str.charAt(i) >= 'a' && str.charAt(i) < 'z')
						|| (str.charAt(i) >= 'A' && str.charAt(i) <= 'Z')
						|| (str.charAt(i) >= '0' && str.charAt(i) <= '9')) {
					py += str.charAt(i);
				} else {
					t = PinyinHelper.toHanyuPinyinStringArray(hanzi[i], t1);
					py = py + t[0];
				}
			}
		} catch (BadHanyuPinyinOutputFormatCombination e) {
			e.printStackTrace();
		}

		return py.trim().toString();
	}

	/**
	 * 从输入流里获取表单信息(产品信息只是给客户看的，程序不需要获取)保存所有导进来的数据（key:列名，value:列值）
	 * 
	 * @param is
	 * @return
	 * @throws Exception
	 */
	public static List<String[]> getDataFromExcel(InputStream is,
			int titleRows) {
		List<String[]> l = null;
		try {
			HSSFWorkbook hssfWorkbook = new HSSFWorkbook(is);
			HSSFSheet hssfSheet = hssfWorkbook.getSheetAt(0);

			l = new ArrayList<String[]>();
			// 循环行Row
			for (int rowNum = titleRows; rowNum <= hssfSheet.getLastRowNum(); rowNum++) {
				HSSFRow hssfRow = hssfSheet.getRow(rowNum);
				if (hssfRow == null) {
					break;
				}
				String[] rowValue = new String[hssfRow.getLastCellNum()];
				// 循环列Cell
				for (int cellNum = 0; cellNum <= hssfRow.getLastCellNum(); cellNum++) {
					HSSFCell hssfCell = hssfRow.getCell(cellNum);
					if (hssfCell == null) {
						continue;
					}
					rowValue[cellNum] = getValue(hssfCell);
				}
				l.add(rowValue);
			}
		} catch (Exception e) {
			return null;
		}
		return l;
	}

	/**
	 * 从输入流里获取表单信息(产品信息只是给客户看的，程序不需要获取)保存所有导进来的数据（key:列名，value:列值）
	 * 
	 * @param is
	 * @return
	 * @throws Exception
	 */
	public static List<String[]> getDataFromXlsx(InputStream is,int titleRows) {
		List<String[]> l = null;

		try {
			XSSFWorkbook xssfWorkbook = new XSSFWorkbook(is);
			XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(0);
			if (xssfSheet == null) {
				return null;
			}
			l = new ArrayList<String[]>();
			// 循环行Row
			for (int rowNum = titleRows; rowNum <= xssfSheet.getLastRowNum(); rowNum++) {
				XSSFRow xssfRow = xssfSheet.getRow(rowNum);
				if (xssfRow == null) {
					continue;
				}
				String[] rowValue = new String[xssfRow.getLastCellNum()];
				// 循环列Cell
				for (int cellNum = 0; cellNum <= xssfRow.getLastCellNum(); cellNum++) {
					XSSFCell xssfCell = xssfRow.getCell(cellNum);
					if (xssfCell == null) {
						continue;
					}
					rowValue[cellNum] = getValue(xssfCell);
				}
				l.add(rowValue);
			}
		} catch (Exception e) {
			return null;
		}
		return l;
	}

	@SuppressWarnings("static-access")  
	private static String getValue(HSSFCell hssfCell) {
		if (hssfCell.getCellType() == hssfCell.CELL_TYPE_BOOLEAN) {
			return String.valueOf(hssfCell.getBooleanCellValue());
		} else if (hssfCell.getCellType() == hssfCell.CELL_TYPE_NUMERIC) {
			return String.valueOf(hssfCell.getNumericCellValue());
		} else {
			return String.valueOf(hssfCell.getStringCellValue());
		}
	}

	@SuppressWarnings("static-access")  
	private static String getValue(XSSFCell xssfCell) {
		if (xssfCell.getCellType() == xssfCell.CELL_TYPE_BOOLEAN) {
			return String.valueOf(xssfCell.getBooleanCellValue());
		} else if (xssfCell.getCellType() == xssfCell.CELL_TYPE_NUMERIC) {
			return String.valueOf(xssfCell.getNumericCellValue());
		} else {
			return String.valueOf(xssfCell.getStringCellValue());
		}
	}
	
	/**
	 * 读取网页内容
	 * @param str	网页地址，例：http://wwww.baidu.com
	 * @return		网页内容
	 * @throws java.io.IOException
	 */
	public static String getHtmlCodeByURL(String str) throws java.io.IOException {
		URL url = new URL(str);
		HttpURLConnection urlConnection  = (HttpURLConnection)url.openConnection();
		InputStream in = urlConnection.getInputStream();
		byte[] data = new byte[in.available()];  
		in.read(data);
		return new String(data);
	}
}
