package com.bcxin.survey.startup;

import com.bcxin.survey.domain.SystemConfig;
import com.bcxin.survey.service.DataService;
import com.bcxin.survey.utils.ConfigUtil;
import com.bcxin.survey.utils.DateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

import javax.servlet.ServletContext;
import java.util.List;
import java.util.Map;

/**
 * 初始化服务类
 * @author Ethan_Huang
 */
@Service("pssInitService")
public class InitService {
	
	public static ServletContext context;

	public static ApplicationContext springContext;
	
	@Autowired
	private DataService dataService;


	public InitService() {
	}
	
	/**
	 * 
	 * <b>Function </b> 初始化环境，定位当前系统的环境
	 * 
	 * @author LuoPeng
	 * @date 2016年12月20日 下午8:52:24
	 */
	private void initEnvi(){
		List<SystemConfig> configList= dataService.findSystemConfigs();
		configList.forEach(config->{
			ConfigUtil.putValue(config.getSyskey(), config.getSysvalue());
		});
		
		Map<String, String> contextMap = ConfigUtil.getData();
		for( String key : contextMap.keySet() ){
			context.setAttribute(key, contextMap.get(key));
		}
		//css/js脚本版本 取项目启动时间来，防止缓存
		context.setAttribute("js_version", DateUtil.getCurrentDate(DateUtil.FORMAT8));

	}
	
	/**
	 * 首次初始化基础数据
	 * @throws Exception 
	 */
	public void initConfigData() {
		initEnvi(); //初始化环境，必须第一个执行这个
//		initLocation();
	}
	
	/**
	 * 
	 * <b>初始化支付环境，目前是 chinaPay </b> 
	 * 
	 * @author LuoPeng
	 * @date 2016年12月15日 下午4:32:05
	 * @注意事项 </b>
	 * <b>
	 */
	public void initPay(){
		
	}
	
	/**
	 * 
	 * <b>初始化阿里云的OSS上传 </b> 
	 * 
	 * @author LuoPeng
	 * @date 2016年12月15日 下午4:32:29
	 * @注意事项 </b>
	 * <b>
	 */
	public void initOss(){
		
	}
	
	/**
	 * 
	 * <b>初始化短信配置 </b> 
	 * 
	 * @author LuoPeng
	 * @date 2016年12月15日 下午4:39:49
	 * @注意事项 </b>
	 * <b>
	 */
	public void initPhoneMessage(){
		
	}
	
	/**
	 * 
	 * <b>初始化发送邮件配置 </b> 
	 * 
	 * @author LuoPeng
	 * @date 2016年12月15日 下午4:40:14
	 * @注意事项 </b>
	 * <b>
	 */
	public void initEmail(){
		
	}
	
	
	/**
	 * 
	 * <b>初始化华泰责任险的投保、支付接口 </b> 
	 * 
	 * @author LuoPeng
	 * @date 2016年12月15日 下午5:35:45
	 * @注意事项 </b>
	 * <b>
	 */
	public void initHTService(){
		
	}
	
	/**
	 * 
	 * <b>初始化系统参数 </b> 
	 * 
	 * @author LuoPeng
	 * @date 2016年12月15日 下午4:32:39
	 * @注意事项 </b>
	 * <b>
	 */
	public void initSystem(){
		
	}
	
}