package com.bcxin.survey.service.wechat;

import com.bcxin.survey.dao.QueryHelper;
import com.bcxin.survey.dao.report.ActivityCooperDao;
import com.bcxin.survey.dao.report.BaseDao;
import com.bcxin.survey.dao.report.TaskDao;
import com.bcxin.survey.domain.activity.Activity;
import com.bcxin.survey.domain.activity.ActivityVenue;
import com.bcxin.survey.domain.activity.Message;
import com.bcxin.survey.domain.dynamic.DynamicTemplateConst;
import com.bcxin.survey.domain.report.Task;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.survey.SurveyPlan;
import com.bcxin.survey.domain.survey.SurveyTask;
import com.bcxin.survey.domain.survey.Survey_FeedBack;
import com.bcxin.survey.domain.survey.Survey_Questionnaire;
import com.bcxin.survey.domain.wechat.AccessToken;
import com.bcxin.survey.enums.dynamic.DynamicPermissionEnum;
import com.bcxin.survey.enums.expert.ExpertTaskStatusEnum;
import com.bcxin.survey.enums.expert.ExpertTaskTypeEnum;
import com.bcxin.survey.enums.report.*;
import com.bcxin.survey.service.CommonService;
import com.bcxin.survey.service.ExpertOrderPublicService;
import com.bcxin.survey.service.NotifyService;
import com.bcxin.survey.service.UserService;
import com.bcxin.survey.service.manage.TaskManageService;
import com.bcxin.survey.service.report.ActivityService;
import com.bcxin.survey.utils.*;
import com.bcxin.survey.utils.sms.SMSUtil;
import com.bcxin.survey.vo.DwzPage;
import com.bcxin.survey.vo.EmailModel;
import com.bcxin.survey.wechat.response.DataDetail;
import com.bcxin.survey.wechat.response.TaskData;
import com.bcxin.survey.wechat.response.TaskNoticeTemplate;
import com.bcxin.survey.wechat.utils.WeixinUtil;
import net.sf.json.JSONObject;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
@Transactional
public class SurveyTaskServiceImpl implements SurveyTaskService {

	@Autowired
	private BaseDao baseDao;
	@Autowired
	private CommonService commonService;
	
	@Autowired
	private UserService userService;
	
	@Autowired
	private AccessTokenService accessTokenService;	
	
	@Autowired
	private SurveyFeedBackService surveyFeedBackService;
	
	@Autowired
	private  TaskManageService taskManageService;

	@Autowired
	private NotifyService notifyService;
	
	@Autowired
	private SurveyQuestionnaireService questionnaireService;
	
	@Autowired
	private SurveyPlanService surveyPlanService;
	
	@Autowired
	private ActivityService activityService;

	@Autowired
	private SurveyManagerUtil surveyManagerUtil;

	@Autowired
	private TaskDao taskDao;

	@Autowired
	private ExpertOrderPublicService orderPublicService;
	@Autowired
	private ActivityCooperDao activityCooperDao;

	@Override
	public boolean saveOrUpdate(SurveyTask surveyTask){
		boolean flag = true;
		try {
			surveyTask.setUpdateOn(new Date());
			baseDao.saveOrUpdate(surveyTask);		
		}catch(Exception e) {
			flag = false;
		}
		return flag;
	}

	@Override
	public SurveyTask findSurveyTaskByOid(long oid){
		SurveyTask task = baseDao.get(SurveyTask.class, oid);
//		Hibernate.initialize(task.getActivity());
		return task;
	}


	@Override
	public SurveyTask findSurveyTaskByTaskIdAndUser(long taskId,User user){
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("task.oid", taskId));
		criterionList.add(Restrictions.eq("user.oid", user.getOid()));
		List<SurveyTaskStatus> taskStatus = new ArrayList<SurveyTaskStatus>();
		taskStatus.add(SurveyTaskStatus.DISTRIBUTE);
		taskStatus.add(SurveyTaskStatus.DOING);
		criterionList.add(Restrictions.in("surveyTaskStatus",taskStatus));
		List<SurveyTask> list = baseDao.findByCriterion(SurveyTask.class, criterionList);
		if(list != null && list.size() > 0) {
			return list.get(0);
		}
		return null;
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public SurveyTask findSurveyTaskByTaskId(long taskId){
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("task.oid", taskId));
		List<SurveyTaskStatus> taskStatus = new ArrayList<SurveyTaskStatus>();
		taskStatus.add(SurveyTaskStatus.DISTRIBUTE);
		criterionList.add(Restrictions.in("surveyTaskStatus",taskStatus));
		List<SurveyTask> list = baseDao.findByCriterion(SurveyTask.class, criterionList);
		if(list != null && list.size() > 0) {
			return list.get(0);
		}
		return null;
	}


	@Override
	public SurveyTask findSurveyTaskByTaskIdAndUserId(long taskId,long userId){
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("task.oid", taskId));
		criterionList.add(Restrictions.eq("user.oid", userId));
		List<SurveyTaskStatus> taskStatus = new ArrayList<SurveyTaskStatus>();
		taskStatus.add(SurveyTaskStatus.DISTRIBUTE);
		taskStatus.add(SurveyTaskStatus.DOING);
		criterionList.add(Restrictions.in("surveyTaskStatus",taskStatus));
		List<SurveyTask> list = baseDao.findByCriterion(SurveyTask.class, criterionList);
		if(list != null && list.size() > 0) {
			return list.get(0);
		}
		return null;
	}


	@Override
	public SurveyTask findSurveyTaskByUserAndTaskCode(User user,String taskCode){
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("user", user));
		criterionList.add(Restrictions.eq("taskCode", taskCode));
		
		List<SurveyTask> list = baseDao.findByCriterion(SurveyTask.class, criterionList);
		if(list != null && list.size() > 0) {
			return list.get(0);
		}
		return null;
	}


	@Override
	public SurveyTask findSurveyTaskByUserAndStatus(User user,SurveyTaskStatus status){
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("user", user));
		if(status !=null) {
			criterionList.add(Restrictions.eq("surveyTaskStatus", status));
		}
		List<Order> orders = new ArrayList<Order>();
		orders.add(Order.desc("updateOn"));
		List<SurveyTask> list = baseDao.findByCriterion(SurveyTask.class, criterionList,orders);
		if(list != null && list.size() > 0) {
			return list.get(0);
		}
		return null;
	}


	@Override
	public SurveyTask findSurveyTaskByUserAndTaskCodeAndStatus(User user,String taskCode ,SurveyTaskStatus status){
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("user", user));
		criterionList.add(Restrictions.eq("taskCode", taskCode));
		criterionList.add(Restrictions.eq("surveyTaskStatus", status));

		List<Order> orders = new ArrayList<Order>();
		orders.add(Order.desc("updateOn"));
		List<SurveyTask> list = baseDao.findByCriterion(SurveyTask.class, criterionList,orders);
		if(list != null && list.size() > 0) {
			return list.get(0);
		}
		return null;
	}

	@Override
	public List<SurveyTask> findSurveyTaskListByUserAndStatus(User user, SurveyTaskStatus status){
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("user.oid", user.getOid()));
		if(status !=null) {
			criterionList.add(Restrictions.eq("surveyTaskStatus", status));
		}
		List<Order> orders = new ArrayList<Order>();
		orders.add(Order.asc("taskCode"));
		return baseDao.findByCriterion(SurveyTask.class, criterionList, orders);
	}


	@Override
	public List<SurveyTask> findSurveyTaskListByUserAndStatusForPage(User user,String surveyName,SurveyTaskStatus status,DwzPage page){
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("user.oid", user.getOid()));
		if(status !=null && !status.equals(SurveyTaskStatus.ALL)) {
			criterionList.add(Restrictions.eq("surveyTaskStatus", status));
		}
		if(StringUtil.isNotEmpty(surveyName)) {
			criterionList.add(Restrictions.like("name", "%" + surveyName + "%"));
		}

		List<Order> orders = new ArrayList<Order>();
		orders.add(Order.desc("taskCode"));
		return baseDao.findByCriterionForPage(SurveyTask.class, criterionList, page, orders);
	}

	/**
	 * 获取踏勘任务列表
	 * @param user
	 * @param surveyName
	 * @param status
	 * @param page
	 * @return
	 */
	@Override
	public List<Map<String,Object>> findSurveyTaskListByUserForPage(User user,String surveyName,SurveyTaskStatus status,DwzPage page){
		int start=(page.getPageNum()-1)*page.getNumPerPage();
		int end=page.getNumPerPage()*page.getPageNum();

		String sqlCount="SELECT count(1) as totalProperty FROM RISK_SURVEYTASK A " +
				"INNER JOIN risk_activity B ON A.activityId = B.oid " +
				"WHERE 1 = 1 ";
		String sql="select DISTINCT " +
				"A.oid,B.`name` as activityName, " +
				"DATE_FORMAT(B.startDate,'%Y-%m-%d %H:%i') as startDate, " +
				"DATE_FORMAT(B.endDate,'%Y-%m-%d %H:%i') as endDate, " +
				"B.sponsor as contacts, " +
				"A.contactMobile, " +
				"A.surveyTaskStatus, " +
				"B.address, " +
				"(select GROUP_CONCAT(DISTINCT N.realName) as tkExperts  " +
				"from risk_survey_expert M,risk_se_user N where M.expertUserId=N.oid and M.taskId=A.taskId " +
				"group by M.taskId) as tkExperts " +
				"from RISK_SURVEYTASK A " +
				"inner join risk_activity B on A.activityId=B.oid " +
				"where 1=1";
		if(user!=null){
			sql+=" and A.userId="+user.getOid();
			sqlCount+=" and A.userId="+user.getOid();
		}
		if(status !=null && !status.equals(SurveyTaskStatus.ALL)) {
			sql+=" and A.surveyTaskStatus='"+status.toString()+"'";
			sqlCount+=" and A.surveyTaskStatus='"+status.toString()+"'";
		}
		if(StringUtil.isNotEmpty(surveyName)) {
			sql+=" and A.`name` like '%"+surveyName+"%'";
			sqlCount+=" and A.`name` like '%"+surveyName+"%'";
		}
		sql+=" order by A.taskCode desc";

		Map<String,Object> map=QueryHelper.findBySql(sql,sqlCount,start,page.getNumPerPage());
		if(map!=null){
			page.setTotalCount(Integer.parseInt(map.get("totalProperty").toString()));
		}

		Object obj =map.get("root");
		List<Map<String,Object>> listMap=new ArrayList<>();
		if(obj!=null){
			List<Map<String,Object>> list=(List<Map<String,Object>>)obj;
			for(Map<String,Object> sub : list){
				SurveyTaskStatus surveyTaskStatus=SurveyTaskStatus.convert(sub.get("surveyTaskStatus").toString());
				sub.put("surveyTaskStatusName",surveyTaskStatus.getName());
				listMap.add(sub);
			}
		}
		return listMap;
	}


	@Override
	public List<SurveyTask> findUnFinishedSurveyTaskListByUser(User user){
		List<Criterion> criterionList = new ArrayList<Criterion>();
		if ( user != null ) {
			criterionList.add(Restrictions.eq("user.oid", user.getOid()));
		}
		criterionList.add(Restrictions.gt("endTime", DateUtil.addDay(new Date(),-1)));
		criterionList.add(Restrictions.ne("surveyTaskStatus", SurveyTaskStatus.DISTRIBUTE));
		criterionList.add(Restrictions.ne("surveyTaskStatus", SurveyTaskStatus.OVERTIME));
		criterionList.add(Restrictions.ne("surveyTaskStatus", SurveyTaskStatus.REFUSE));
		criterionList.add(Restrictions.ne("surveyTaskStatus", SurveyTaskStatus.TRANSFER));
		criterionList.add(Restrictions.ne("surveyTaskStatus", SurveyTaskStatus.TRANSFERAUDIT));
		
		List<Order> orders = new ArrayList<Order>();
//		orders.add(Order.asc("feedBacks.surveyStep"));
		orders.add(Order.asc("taskCode"));
		return baseDao.findByCriterion(SurveyTask.class, criterionList, orders);
	}


	@Override
	public List<SurveyTask> findUnFinishedSurveyTaskListByUserForPage(User user,DwzPage page){
		List<Criterion> criterionList = new ArrayList<Criterion>();
		if ( user != null ) {
			criterionList.add(Restrictions.eq("user.oid", user.getOid()));
		}
		criterionList.add(Restrictions.gt("endTime", DateUtil.addDay(new Date(),-1)));
		criterionList.add(Restrictions.ne("surveyTaskStatus", SurveyTaskStatus.DISTRIBUTE));
		criterionList.add(Restrictions.ne("surveyTaskStatus", SurveyTaskStatus.OVERTIME));
		criterionList.add(Restrictions.ne("surveyTaskStatus", SurveyTaskStatus.REFUSE));
		criterionList.add(Restrictions.ne("surveyTaskStatus", SurveyTaskStatus.TRANSFER));
		criterionList.add(Restrictions.ne("surveyTaskStatus", SurveyTaskStatus.TRANSFERAUDIT));
		
		List<Order> orders = new ArrayList<Order>();
//		orders.add(Order.asc("feedBacks.surveyStep"));
		orders.add(Order.asc("taskCode"));
		return baseDao.findByCriterionForPage(SurveyTask.class, criterionList, page, orders);
	}


	@Override
	public List<SurveyTask> findSurveyTaskListByStatus(SurveyTaskStatus status){
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("surveyTaskStatus", status));
		return baseDao.findByCriterion(SurveyTask.class, criterionList);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<SurveyTask> findSurveyTaskListByUserAndStatusAndDateForDay(User user, SurveyTaskStatus status, Date month) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("user", user));
		if(status !=null) {
			criterionList.add(Restrictions.eq("surveyTaskStatus", status));
		}
		if(month != null) {
			criterionList.add(Restrictions.between("createOn", month, DateUtil.addDay(month, 1)));
		}
		List<Order> orders = new ArrayList<Order>();
		orders.add(Order.asc("createOn"));
		return baseDao.findByCriterion(SurveyTask.class, criterionList, orders);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<SurveyTask> findSurveyTaskListByUserAndStatusAndDateForMonth( User user, SurveyTaskStatus status, Date month) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("user", user));
		if(status !=null) {
			criterionList.add(Restrictions.eq("surveyTaskStatus", status));
		}
		if(month != null) {
			criterionList.add(Restrictions.between("createOn", month, DateUtil.addMonth(month, 1)));
		}
		return baseDao.findByCriterionForPage(SurveyTask.class, criterionList, null, Order.asc("createOn"));
	}

	@Override
	public TaskNoticeTemplate getTaskNoticeTemplate(SurveyTask surveyTask,String taskNoticeTemplateId,String url){
		TaskNoticeTemplate taskNotice = new TaskNoticeTemplate();
//		taskNotice.setTouser(surveyTask.getUser().getOpenId());
		taskNotice.setUrl(url);
		taskNotice.setTemplate_id(taskNoticeTemplateId);

		DataDetail keyword1 = new DataDetail();
		DataDetail keyword2 = new DataDetail();
		DataDetail keyword3 = new DataDetail();
		DataDetail first = new DataDetail();
		DataDetail remark = new DataDetail();
		if(surveyTask.getSurveyTaskStatus().equals(SurveyTaskStatus.DISTRIBUTE)) {
			first.setValue("您有新的任务");
		}else {
			first.setValue("您有新的转交任务");
		}
		first.setColor("#173177");
		keyword1.setValue(surveyTask.getTaskCode());
		keyword1.setColor("#173177");
		keyword2.setValue(surveyTask.getSurveyTaskStatus().getName());
		keyword2.setColor("#173177");
		keyword3.setValue(DateUtil.convertDateToString(surveyTask.getCreateOn(),"yyyy-MM-dd HH:ss"));
		keyword3.setColor("#173177");
		remark.setValue("请到我的任务中查看并处理！");
		remark.setColor("#173177");
		TaskData task = new TaskData();
		task.setFirst(first);
		task.setKeyword1(keyword1);
		task.setKeyword2(keyword2);
		task.setKeyword3(keyword3);
		task.setRemark(remark);
		taskNotice.setData(task);
		
		return taskNotice;
	}

	@Override
	public void sendWeixinMsg(SurveyTask surveyTask){
		String url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + GlobalResources.APPID + "&redirect_uri=http://" + GlobalResources.DOMAINNAME + "/wechat/task/taskList/init?weChat=1&response_type=code&scope=snsapi_userinfo&state=1#wechat_redirect";
		TaskNoticeTemplate taskNotice = getTaskNoticeTemplate(surveyTask, GlobalResources.TASKTEMPLATEID, url);
		String sendMsg = JSONObject.fromObject(taskNotice).toString();
		AccessToken accessToken = accessTokenService.getAccessToken();
		if(WeixinUtil.sendTemplateMsg(sendMsg,accessToken)){
			System.out.println("发送OK");
		}else {
			System.out.println("发送失败");
		}
	}

	/**
	 * 转交勘查任务
	 */
	@Override
	public boolean transferTask(SurveyTask surveyTask) {
		boolean flag = true;
		List<Survey_FeedBack> feedBacks = surveyFeedBackService.findSurvey_FeedBackListBySurveyTaskId(surveyTask.getOid());
		List<SurveyPlan> plans = surveyPlanService.findSurveyPlanListBySurveyTaskId(surveyTask.getOid());
		Task task = surveyTask.getTask();
		SurveyTask newTask = new SurveyTask();
		newTask.setCreateOn(new Date());
		newTask.setTask(task);
		newTask.setActivity(task.getActivity());
		try {
			newTask.setActivityTime(surveyTask.getActivityTime());
			newTask.setEndTime(surveyTask.getEndTime());
			newTask.setAddress(surveyTask.getAddress());
			newTask.setContactMobile(surveyTask.getContactMobile());
			newTask.setContacts(surveyTask.getContacts());
			newTask.setName(surveyTask.getName());
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		newTask.setTaskCode(System.currentTimeMillis()+"");
		
		newTask.setUser((User)task.getAssgin());
		newTask.setSurveyTaskStatus(SurveyTaskStatus.DOING);
		saveOrUpdate(newTask);
//		sendWeixinMsg(newTask);//取消微信通知
		String content = "您有新的勘查任务，请登录微信公众号查看！";
		notifyService.sendHuaWeiSMS(task.getAssgin().getPhone(),content, Const.ENVI_TK, DictConst.SMSCODE_B10,new String[]{});
		
		//邮件通知
		EmailModel model = new EmailModel();
		model.setSubject("勘查任务");
		model.setEmailType(EmailMsgType.SURVEYTASK);
		model.setContent("您有新的勘查任务，请登录微信公众号查看！");
		model.setTo(task.getAssgin().getEmail());
		notifyService.sendEmail(model);
		
		for (Survey_FeedBack survey_FeedBack : feedBacks) {
			survey_FeedBack.setUser(newTask.getUser());
			survey_FeedBack.setSurveyTask(newTask);
			if(!surveyFeedBackService.saveOrUpdate(survey_FeedBack)) {
				flag = false;
			}
		}
		for (SurveyPlan surveyPlan : plans) {
			surveyPlan.setUser(newTask.getUser());
			surveyPlan.setSurveyTask(newTask);
			if(!surveyPlanService.saveOrUpdate(surveyPlan)) {
				flag = false;
			}
		}
		return flag;
	}
	
	/**
	 * 发布勘查任务
	 */
	@Override
	public void distributeTask(Task task){
		User user = userService.findUserByOid(task.getAssgin().getOid());
		SurveyTask existTask = findSurveyTaskByTaskId(task.getOid());
		if(existTask != null){
			existTask.setSurveyTaskStatus(SurveyTaskStatus.TRANSFER);
		}
		
		SurveyTask surveyTask = new SurveyTask();
		surveyTask.setCreateOn(new Date());
		surveyTask.setTask(task);
		try {
			Activity activity = task.getActivity();
			surveyTask.setActivity(activity);
			surveyTask.setActivityTime(DateUtil.convertStringToDate(activity.getStartDate()));
			surveyTask.setEndTime(DateUtil.convertStringToDate(activity.getEndDate()));
			surveyTask.setAddress(activity.getAddress());
			surveyTask.setContactMobile(activity.getUser().getPhone());
			surveyTask.setContacts(activity.getSponsor());
			surveyTask.setName(activity.getName());
			surveyTask.setTaskCode(System.currentTimeMillis()+"");
			surveyTask.setUser(user);
			surveyTask.setSurveyTaskStatus(SurveyTaskStatus.DISTRIBUTE);
			saveOrUpdate(surveyTask);
//			sendWeixinMsg(surveyTask);//二期 采用账户登录 取消微信通知
			
			//手机短信通知
			String content = "您有新的勘查任务，请登录微信公众号查看！";
			notifyService.sendHuaWeiSMS(task.getAssgin().getPhone(),content, Const.ENVI_TK, DictConst.SMSCODE_B10,new String[]{});
			//邮件通知
			EmailModel model = new EmailModel();
			model.setSubject("勘查任务");
			model.setEmailType(EmailMsgType.SURVEYTASK);
			model.setContent("您有新的勘查任务，请登录微信公众号查看！");
			model.setTo(task.getAssgin().getEmail());
			notifyService.sendEmail(model);
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		try {
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * 接收任务
	 */
	@Override
	public JSONObject receiveTask(Long taskId) {
		String message = "";
		String status = "200";
		Date now = new Date();
		JSONObject json = new JSONObject();
		
		SurveyTask surveyTask = findSurveyTaskByOid(taskId);
		SurveyTaskStatus taskStatus = surveyTask.getSurveyTaskStatus();
		if((now.getTime() - surveyTask.getUpdateOn().getTime())/10800000 >1){
			message = "任务已超过三小时未接受！";
			taskStatus = SurveyTaskStatus.OVERTIME;
			// 共享专家接受
			orderPublicService.updateStatus(surveyTask.getActivity().getOid(),surveyTask.getUser().getOid(),
					ExpertTaskTypeEnum.SURVEY.getKey(),ExpertTaskStatusEnum.CANCEL.getKey());
		}else{
			taskStatus = SurveyTaskStatus.DOING;
			message ="您已接受勘查任务“"+surveyTask.getName()+"”请尽快与相关人员联系勘查事宜!";
		}
		
		surveyTask.setSurveyTaskStatus(taskStatus);
		if(!saveOrUpdate(surveyTask)){
			status="300";
			message ="接受失败！";
		}else{
			if(surveyTask.getSurveyTaskStatus().equals(SurveyTaskStatus.DOING)){
				taskManageService.acceptTask(surveyTask.getTask());
				// 共享专家接受
				orderPublicService.updateStatus(surveyTask.getActivity().getOid(),surveyTask.getUser().getOid(),
						ExpertTaskTypeEnum.SURVEY.getKey(),ExpertTaskStatusEnum.ACCEPT.getKey());
//				Task tast = taskDao.findTaskByOid(surveyTask.getTask().getOid());
//				SurveyStep[] surveySteps = SurveyStep.leveConvert(tast.getTKConfigLeve());
				SurveyStep[] surveySteps = SurveyStep.values();
				for (SurveyStep surveyStep : surveySteps) {
					Survey_FeedBack feedBack = new Survey_FeedBack();
					feedBack.setSurveyStep(surveyStep);
					feedBack.setSurveyTask(surveyTask);
					feedBack.setUser(surveyTask.getUser());
					feedBack.setCreateOn(new Date());
					feedBack.setTaskStatus(FeedBackStatusEnum.NON);
					surveyFeedBackService.saveOrUpdate(feedBack);
					
					List<ActivityVenue> list = activityService.findActivityVenuesByActivity(surveyTask.getActivity());
					for (ActivityVenue activityVenue : list) {
						Survey_Questionnaire questionnaire = new Survey_Questionnaire();
						questionnaire.setVenue(activityVenue.getVenue());
						questionnaire.setCreateOn(new Date());
						questionnaire.setFeedBack(feedBack);
						questionnaire.setSurveyStep(feedBack.getSurveyStep());
						questionnaire.setTaskStatus(QuestionStatusEnum.NON);
						questionnaireService.saveOrUpdate(questionnaire);
					}
				}

				//发送通知给勘查项目经理和勘查区域经理
				if (surveyTask != null) {

					User user = userService.getCurrentUser();
					Activity activity = surveyManagerUtil.selectActivity(surveyTask);
					Task task = surveyManagerUtil.selectTaskBySurveyTask(surveyTask);
					// 获取风评机构id
					Long orgId=commonService.getFengPingOrg(activity);

					// 接受任务，保存动态看板
					DynamicUtil.getBean().saveTKData(user,DynamicTemplateConst.DYNAMIC_TEMP_KANCHA_400003,surveyTask.getTask().getOid(),DynamicPermissionEnum.DYNAMIC_FENGPING);

					//查询勘查项目经理
					List<User> userList = userService.findUserListByOrgIdAndUserType(orgId, DictConst.USERTYPE_DSFFWJGYH_TKXMJL);
					for (User pm : userList) {
						//手机短信通知
						String content = user.getRealName() + "已接受勘查任务" + surveyTask.getName() + "。";
						notifyService.sendHuaWeiSMS(pm.getPhone(),content, Const.ENVI_TK, DictConst.SMSCODE_B11,new String[]{user.getRealName(),surveyTask.getName()});
						//邮件通知
						EmailModel model = new EmailModel();
						model.setSubject(user.getRealName() + "已接受勘查任务");
						model.setEmailType(EmailMsgType.SURVEYTASK);
						model.setContent(user.getRealName() + "已接受勘查任务" + surveyTask.getName() + "。【" + SMSUtil.platFormName() + "】");
						model.setTo(pm.getEmail());
						notifyService.sendEmail(model);
					}


					// 发送系统消息
					if (user != null && activity != null && task != null) {
						Message msg = new Message();
						msg.setContent(user.getRealName() + "已接受勘查任务" + surveyTask.getName() + "。");
						msg.setTitle(user.getRealName() + "已接受勘查任务");
						msg.setKeyword("立即查看");
						msg.setUrl("/survey/task/detail/" + task.getOid());
						surveyManagerUtil.saveMessage(surveyTask, msg);
					}
				}
			} else {
				taskManageService.refuseTask(surveyTask.getTask());
				// 共享专家拒绝
				orderPublicService.updateStatus(surveyTask.getActivity().getOid(),surveyTask.getUser().getOid(),
						ExpertTaskTypeEnum.SURVEY.getKey(),ExpertTaskStatusEnum.REFUSE.getKey());
			}
		}
		json.put("status", status);
		json.put("message", message);
		json.put("taskStatusName", taskStatus.getName());
		json.put("taskStatus", taskStatus);
		return json;
	}

	@Override
	public JSONObject refuseTask(Long taskId) {
		String message = "";
		String status = "300";
		JSONObject json = new JSONObject();
		
		SurveyTask surveyTask = findSurveyTaskByOid(taskId);
		surveyTask.setSurveyTaskStatus(SurveyTaskStatus.REFUSE);		
		
		if(saveOrUpdate(surveyTask)){
			taskManageService.refuseTask(surveyTask.getTask());
			// 共享专家拒绝
			orderPublicService.updateStatus(surveyTask.getActivity().getOid(),surveyTask.getUser().getOid(),
					ExpertTaskTypeEnum.SURVEY.getKey(),ExpertTaskStatusEnum.REFUSE.getKey());
			status="200";
			message ="任务已拒绝，任务将会重新分配！";

			//发送通知给勘查项目经理和勘查区域经理
			if (surveyTask != null) {

				Activity activity = surveyManagerUtil.selectActivity(surveyTask);
				Task task = surveyManagerUtil.selectTaskBySurveyTask(surveyTask);
				User user = userService.getCurrentUser();
				// 获取风评机构id
				Long orgId=commonService.getFengPingOrg(activity);

				// 拒绝任务，保存动态看板
				DynamicUtil.getBean().saveTKData(user,DynamicTemplateConst.DYNAMIC_TEMP_KANCHA_400004,surveyTask.getTask().getOid(),DynamicPermissionEnum.DYNAMIC_FENGPING);

				//查询勘查项目经理
				List<User> userList = userService.findUserListByOrgIdAndUserType(orgId, DictConst.USERTYPE_DSFFWJGYH_TKXMJL);
				for (User pm : userList) {
					//手机短信通知
					String content = user.getRealName() + "已拒绝勘查任务" + surveyTask.getName() + "。";
					notifyService.sendHuaWeiSMS(pm.getPhone(),content, Const.ENVI_TK, DictConst.SMSCODE_B12,new String[]{user.getRealName(),surveyTask.getName()});
					//邮件通知
					EmailModel model = new EmailModel();
					model.setSubject(user.getRealName() + "已拒绝勘查任务");
					model.setEmailType(EmailMsgType.SURVEYTASK);
					model.setContent(user.getRealName() + "已拒绝勘查任务" + surveyTask.getName() + "。【" + SMSUtil.platFormName() + "】");
					model.setTo(pm.getEmail());
					notifyService.sendEmail(model);
				}

				// 发送消息
				if (user != null && activity != null && task != null) {
					Message msg = new Message();
					msg.setContent(user.getRealName() + "已拒绝勘查任务" + surveyTask.getName() + "。");
					msg.setTitle(user.getRealName() + "已拒绝勘查任务");
					msg.setKeyword("立即查看");
					msg.setUrl("/survey/task/taskPageList");
					surveyManagerUtil.saveMessage(surveyTask, msg);
				}
			}
		}else{
			status="300";
			message ="拒绝失败！";
		}
		json.put("status", status);
		json.put("message", message);
		json.put("taskStatusName", SurveyTaskStatus.REFUSE.getName());
		return json;
	}

	@SuppressWarnings("unchecked")
	@Override
	public SurveyTask findSurveyTaskByReportOid(long oid) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("report.oid", oid));
		criterionList.add(Restrictions.ne("surveyTaskStatus", SurveyTaskStatus.OVERTIME));
		criterionList.add(Restrictions.ne("surveyTaskStatus", SurveyTaskStatus.REFUSE));
		criterionList.add(Restrictions.ne("surveyTaskStatus", SurveyTaskStatus.TRANSFER));
		criterionList.add(Restrictions.ne("surveyTaskStatus", SurveyTaskStatus.TRANSFERAUDIT));
		List<SurveyTask> list = baseDao.findByCriterion(SurveyTask.class, criterionList);
		if(list != null && list.size() > 0) {
			return list.get(0);
		}
		return null;
	}


	@Override
	public User selectExpertBySurveyTaskId(long taskId) {
		return taskDao.selectExpertBySurveyTaskId(taskId);
	}

	@Override
	public List<Map<String,Object>> selectExpertBySurveyTaskIdList(List<Long> taskIdList) {

			StringBuilder stringBuilder = new StringBuilder();
			for (Long taskId : taskIdList) {
				stringBuilder.append(taskId + ",");
			}
			stringBuilder.deleteCharAt(stringBuilder.length() - 1);

		return taskDao.selectExpertBySurveyTaskIdList(stringBuilder);
	}


	/**
	 * 查询踏勘阶段专家记录数量
	 * @param taskId
	 * @return
	 */
	@Override
	public Integer selectStepExpert(Long taskId){
		return taskDao.selectStepExpert(taskId);
	}

	@Override
	public String selectStepExpertName(Long surveyTaskId){
		return taskDao.selectStepExpertName(surveyTaskId);
	}

	@Override
	public String selectStepExpertName(Long taskId,String surveyStep){
		return taskDao.selectStepExpertName(taskId,surveyStep);
	}

}
