package com.bcxin.survey.service.wechat;

import com.bcxin.survey.dao.report.BaseDao;
import com.bcxin.survey.domain.survey.Survey_Photo;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
@Transactional
public class SurveyPhotoServiceImpl implements SurveyPhotoService {

	@Autowired
	private BaseDao baseDao;

	@Override
	public boolean saveOrUpdate(Survey_Photo photo){
		boolean flag = true;
		try {
			photo.setUpdateOn(new Date());
			baseDao.saveOrUpdate(photo);		
		}catch(Exception e) {
			flag = false;
		}
		return flag;
	}

	@Override
	public boolean delete(Survey_Photo photo){
		boolean flag = true;
		try {
			baseDao.delete(photo);		
		}catch(Exception e) {
			e.getStackTrace();
			System.out.println(e.getMessage());
			flag = false;
		}
		return flag;
	}

	@Override
	public Survey_Photo findSurveyPhotoByOid(long oid){
		return baseDao.get(Survey_Photo.class, oid);
	}
	public void deleteAllSurveyPhotoByOidList(List<Long> idList){
		if(idList.size()==0){
			return;
		}
		System.out.println("==========> deleteAllSurveyPhotoByOidList.文件删除业务.star----------");
		Long[] arr = (Long[]) idList.toArray();
		System.out.println("==========> deleteAllSurveyPhotoByOidList.文件删除业务.idList："+idList.toArray());
		List<Criterion> criterion1List = new ArrayList<Criterion>();
		criterion1List.add(Restrictions.in("oid", arr));
		List<Survey_Photo> list = baseDao.findByCriterion(Survey_Photo.class,criterion1List);
		System.out.println("==========> deleteAllSurveyPhotoByOidList.文件删除业务.list："+list.size());
		for(Survey_Photo photo:list){
			delete(photo);
		}
		System.out.println("==========> deleteAllSurveyPhotoByOidList.文件删除业务.succ-------");
	}

	@Override
	public List<String> findPhotoListByInfoId(long infoId) {

		StringBuffer sql = new StringBuffer("SELECT path FROM RISK_Survey_Photo WHERE 1=1 ");

		sql.append(" and surveyInfoId = "+infoId);
		List<String> dtoList = Lists.newArrayList();
		List<Map<String,Object>> list = baseDao.findBySQL(sql.toString(),null);
		list.forEach(result->{
			dtoList.add(result.get("path").toString());
		});
		return dtoList;
	}
}
