package com.bcxin.survey.service.wechat;

import com.bcxin.survey.dao.report.BaseDao;
import com.bcxin.survey.domain.wechat.CheckCode;
import com.bcxin.survey.utils.DateUtil;
import com.bcxin.survey.utils.StringUtil;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


@Service
@Transactional
public class CheckCodeServiceImpl implements CheckCodeService {
	
	@Autowired
	private BaseDao baseDao;

	@Override
	public boolean saveOrUpdate(CheckCode checkCode){
		boolean flag = true;
		try {
			if(checkCode != null){
				checkCode.setUpdateOn(new Date());				
				baseDao.saveOrUpdate(checkCode);
			}
		} catch(Exception e) {
			flag = false;
		}
		return flag;
	}

	@Override
	public CheckCode getCheckCode(String openId){
		String code = StringUtil.getCheckCode(6);
		String requestId = DateUtil.generatorRadomNumber();
		CheckCode checkCode = new CheckCode();
		checkCode.setCode(code);
		checkCode.setOpenId(openId);
		checkCode.setRequestId(requestId);
		checkCode.setCreateOn(new Date());
		saveOrUpdate(checkCode);
		return checkCode;
	}

	@Override
	public CheckCode findCheckCodeByCodeAndRequestId(String code, String requestId){
		List<Criterion> criterions = new ArrayList<Criterion>();
		criterions.add(Restrictions.eq("code", code));
		criterions.add(Restrictions.eq("requestId", requestId));
		List<CheckCode> checkCodes = baseDao.findByCriterion(CheckCode.class, criterions);
		if(checkCodes != null && checkCodes.size() > 0) {
			return checkCodes.get(0);
		}
		return null;
	}
}
