package com.bcxin.survey.service.report;

import cn.hutool.core.bean.BeanUtil;
import com.bcxin.survey.dao.QueryHelper;
import com.bcxin.survey.dao.report.BaseDao;
import com.bcxin.survey.domain.activity.*;
import com.bcxin.survey.utils.CollectionUtil;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

@Service
@Transactional
public class ActivityServiceImpl implements ActivityService {

	@Autowired
	private BaseDao baseDao;
	
	@Override
	public Activity findActivityByOid(Long oid){
		return baseDao.get(Activity.class, oid);
	}

	@Override
	public Activity findActivityByActivityNo(String activityNo){
		List<Criterion> criterions = new ArrayList<Criterion>();
		criterions.add(Restrictions.eq("activityNo", activityNo));
		List list = baseDao.findByCriterion(Activity.class, criterions);
		if (cn.hutool.core.collection.CollectionUtil.isEmpty(list)) {
			return null;
		}
		return (Activity) list.get(0);
	}

	@Override
	public void dateRecord(Activity activity, String activitySubStep,String relationId ){
		ActivityRecord record = findRecordByStep(activitySubStep, activity);
		if ( record == null ) {
			record = new ActivityRecord();
			record.setCreateOn(new Date());
			record.setUpdateOn(new Date());
			record.setUpdateOn(record.getCreateOn());
			record.setActivity(activity);
			record.setActivitySubStep(activitySubStep);
			record.setRelationId(relationId);
			baseDao.save(record);
		}
	}

	private ActivityRecord findRecordByStep(String activitySubStep, Activity activity) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("activitySubStep",activitySubStep));
		criterionList.add(Restrictions.eq("activity", activity));
		List<ActivityRecord> records = baseDao.findByCriterion(ActivityRecord.class, criterionList);
		if(records != null && records.size() >0){
			return records.get(0);
		}
		return null;
	}
	
	@Override
	public List<ActivityVenue> findActivityVenuesByActivity(Activity activity){
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("activity", activity));
		return baseDao.findByCriterion(ActivityVenue.class, criterionList);
	}

	@Override
	public OrderForm findOrderByActivity(Activity activity) {
		List<Criterion> criterionList = new ArrayList<Criterion>();
		criterionList.add(Restrictions.eq("activity", activity));
		List<OrderForm> orders = baseDao.findByCriterion(OrderForm.class, criterionList);
		if(orders != null && orders.size() >0){
			return orders.get(0);
		}
		return null;
	}

	@Override
	public void activityMaterial(String activityMaterialType,String reportPath, Activity activity){
		ActivityMaterial material = findReportByActivity(activityMaterialType, activity);
		if ( material == null ) {
			material = new ActivityMaterial();
			material.setCreateOn(new Date());
			material.setUpdateOn(new Date());
			material.setActivity(activity);
			material.setValue(reportPath);
			material.setActivityMaterialType(activityMaterialType);
		} else {
			material.setValue(reportPath);
		}
		baseDao.save(material);
	}


	private ActivityMaterial findReportByActivity(String activityMaterialType, Activity activity) {
		List<Criterion> criterionList = Lists.newArrayList();
		criterionList.add(Restrictions.eq("activityMaterialType",activityMaterialType));
		criterionList.add(Restrictions.eq("activity", activity));
		List<ActivityMaterial> records = baseDao.findByCriterion(ActivityMaterial.class, criterionList);
		if(records != null && records.size() >0){
			return records.get(0);
		}
		return null;
	}


	@Override
	public List<Activity> selectActivityBySurveyTaskId(Long oid) {
		List<Activity> activityList = Lists.newArrayList();
		StringBuffer sql = new StringBuffer();
		sql.append("SELECT a.* FROM risk_activity a INNER JOIN risk_surveytask b ON a.oid = b.activityId WHERE b.oid = " + oid);
		List<Object> list = QueryHelper.findBySql(sql.toString(), null);
		if (CollectionUtil.isNotEmpty(list)) {
			list.forEach(obj -> {
				Map<String, Object> map = (HashMap<String, Object>) obj;
				Activity activity = BeanUtil.mapToBean(map, Activity.class, true);
				activityList.add(activity);
			});
		}
		return activityList;
	}

	@Override
	public Venue selectVenueById(Long oid) {
		List<Venue> venueList = Lists.newArrayList();
		StringBuffer sql = new StringBuffer();
		sql.append("SELECT name FROM sys_venue WHERE oid = " + oid);
		List<Object> list = QueryHelper.findBySql(sql.toString(), null);
		if (CollectionUtil.isNotEmpty(list)) {
			list.forEach(obj -> {
				Map<String, Object> map = (HashMap<String, Object>) obj;
				Venue venue = BeanUtil.mapToBean(map, Venue.class, true);
				venueList.add(venue);
			});
		}
		if (CollectionUtil.isNotEmpty(venueList)) {
			return venueList.get(0);
		}
		return null;
	}

}
