package com.bcxin.survey.service.manage;

import com.bcxin.survey.service.common.ScheduleService;
import com.bcxin.survey.service.wechat.SurveyTagService;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class Scheduling {

	@Resource
	private SurveyTagService surveyTagService;
	
	@Resource
	private TaskManageService taskManageService;

	@Resource
	private ScheduleService scheduleService;
	
	//@Scheduled(fixedDelay=1000)  //第一种方式
	//fixedDelay延时多少毫秒，多少毫秒执行一次
	//@Scheduled(cron="0 * * * * *")     //第二种方式
	//1 Seconds (0-59)
	//2 Minutes (0-59)
	//3 Hours (0-23)
	//4 Day of month (1-31)
	//5 Month (1-12 or JAN-DEC)
	//6 Day of week (1-7 or SUN-SAT)
	//7 Year (1970-2099)
	//取值：可以是单个值，如6；
	//	也可以是个范围，如9-12；
	//	也可以是个列表，如9,11,13
	//	也可以是任意取值，使用*
	//0 * * * * * 代表每分钟执行一次
	//•"0 0 * * * *" = 每一小时执行一次.
	//•"*/10 * * * * *" = 没10秒执行一次.
	//•"0 0 8-10 * * *" = 每天8, 9 和 10 点整.
	//•"0 0/30 8-10 * * *" = 每天8:00, 8:30, 9:00, 9:30 和 10 点整.
	//•"0 0 9-17 * * MON-FRI" = 每周一到周五9-17点
	//•"0 0 0 25 12 ?" = 每一个圣诞节的午夜
	
	//"0 0 12 * * ?"    每天中午十二点触发 
	//"0 15 10 ? * *"    每天早上10：15触发 
	//"0 15 10 * * ?"    每天早上10：15触发 
	//"0 15 10 * * ? *"    每天早上10：15触发 
	//"0 15 10 * * ? 2005"    2005年的每天早上10：15触发 
	//"0 * 14 * * ?"    每天从下午2点开始到2点59分每分钟一次触发 
	//"0 0/5 14 * * ?"    每天从下午2点开始到2：55分结束每5分钟一次触发 
	//"0 0/5 14,18 * * ?"    每天的下午2点至2：55和6点至6点55分两个时间段内每5分钟一次触发 
	//"0 0-5 14 * * ?"    每天14:00至14:05每分钟一次触发 
	//"0 10,44 14 ? 3 WED"    三月的每周三的14：10和14：44触发 
	//"0 15 10 ? * MON-FRI"    每个周一、周二、周三、周四、周五的10：15触发
	
	
//	@Scheduled(fixedDelay = 10000)
//	public void end_release(){ //读取上行短信
//		parkingLotReleaseService.endRelease();
//		System.out.println("结束");
//	}
	
	
	@Scheduled(cron="0 0 9 * * ?")//每天9点
	public void getSurveyTagsFromCMS(){
		surveyTagService.getSurveyTagsFromCMS();
	}
	
	@Scheduled(cron="0 */30 * * * ?")//每30分钟执行一次
	public void sendUnReceiveTaskMsgForCM(){
		taskManageService.sendUnReceiveTaskMsgForPM();
	}
	
	@Scheduled(cron="0 */20 * * * *")//每20分钟执行一次
	public void endOverTimeTask(){
		taskManageService.endOverTimeTask();
	}

	@Scheduled(cron="0 0 * * * *")//每小时执行一次
	public void syncUnCompleteTask(){
		scheduleService.syncUnCompleteTask();
	}

	@Scheduled(cron="0 0 * * * *")//每小时执行一次
	public void syncUnCompleteMaterialTask(){
		scheduleService.syncUnCompleteMaterialTask();
	}
}
