package com.bcxin.survey.service.log;

import com.bcxin.survey.dao.log.SysLogDao;
import com.bcxin.survey.domain.log.SysLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service("sysLogService")
@Transactional(propagation = Propagation.REQUIRES_NEW)
public class SysLogServiceImpl implements SysLogService {

    @Autowired
    SysLogDao logDao;

    @Override
    public void saveLog(SysLog sysLog) {
        logDao.saveLog(sysLog);
    }

    @Override
    public void saveLog(String method, String content, boolean isFail) {
        logDao.saveLog(method,content,isFail);
    }

    @Override
    public void saveLog(String method, String content, Exception e) {
        logDao.saveLog(method,content,e);
    }
}
