package com.bcxin.survey.service;

import com.bcxin.survey.domain.activity.Activity;
import com.bcxin.survey.domain.security.Org;
import com.bcxin.survey.domain.security.Role;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.domain.survey.SurveyAssist;
import com.bcxin.survey.vo.DwzPage;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

public interface UserService {

	User getCurrentUser();

	String register(HttpServletRequest request, MultipartFile certFile);

	String resetPassword(String oldPassword, String password);

	String restorePassword(String password);

	User selectUserByPerId(String perId);

	User findUserByName(String name);

	User findUserByOid(long oid);

	User getCurrentUser(String weChat, String code);

	void setAuthentication(String userName, HttpServletRequest request);

	Boolean checkPhoneMsg(String securityCode, String phone, HttpServletRequest request);

	void save(User user);

	String getOpenId(String weChat, String code);

	Boolean checkPassword(User user, String oldPassword);

	void saveNewPassword(User user, String newPassword);

	Role findRoleByOid(Long oid);

	List<User> findUserListByOrgIdAndUserType(Long orgId, String userType);

	List<User> findAllUserListForManage(User user);

	List<User> findAllUserListForPage(User user, DwzPage page);

	List<User> findSurveyExpertUser(Activity activity);

	List<User> findActivityExpertUser(SurveyAssist surveyAssist);

	List<User> listTKManager(Long oid);

	List<User> findExpertUser(Long orgId, String userType);

	User selectServiceOrgRegister(Org org);

	List<User> selectServiceOrgPersonByList(List<String> userTypeList, Long oid);

}