package com.bcxin.survey.service;

import com.bcxin.survey.dao.QueryHelper;
import com.bcxin.survey.dao.report.ActivityCooperDao;
import com.bcxin.survey.dao.report.MaterialTaskDao;
import com.bcxin.survey.dao.report.SyncTaskDao;
import com.bcxin.survey.domain.activity.Activity;
import com.bcxin.survey.domain.data.MaterialTask;
import com.bcxin.survey.domain.data.SyncTask;
import com.bcxin.survey.domain.security.Org;
import com.bcxin.survey.domain.security.User;
import com.bcxin.survey.dto.ActivityCooperDTO;
import com.bcxin.survey.utils.DictConst;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;

/**
 * 
 * <b>通用的 </b>
 * 
 * @author LuoPeng
 * @date 2018年05月17日 下午1:50:51
 * @注意事项 </b>
 * <b>
 */
@Service("commonService")
@Transactional
public class CommonServiceImpl implements CommonService {

	@Resource
	private SyncTaskDao syncTaskDao;

	@Resource
	private MaterialTaskDao materialTaskDao;
	@Autowired
	private ActivityCooperDao activityCooperDao;

	@Override
	public SyncTask instance(String SyncTaskType, String param){
		SyncTask task = new SyncTask();
		task.setSuccess("0");
		task.setSyncTaskType(SyncTaskType);
		task.setParam(param);
		task.setCreateOn(new Date());
		syncTaskDao.save(task);
		return task;
	}


	@Override
	public SyncTask instance(String activityNo,String SyncTaskType, String param){
		SyncTask task = new SyncTask();
		task.setSuccess("0");
		task.setSyncTaskType(SyncTaskType);
		task.setParam(param);
		task.setActivityNo(activityNo);
		task.setCreateOn(new Date());
		syncTaskDao.save(task);
		return task;
	}

	@Override
	public MaterialTask mtInstance(String activityNo, String content,String materialTask){
		MaterialTask task = new MaterialTask();
		task.setActivityNo(activityNo);
		task.setSuccess(DictConst.N);
		task.setMaterialTaskType(materialTask);
		task.setContent(content);
		task.setCreateOn(new Date());
		materialTaskDao.save(task);
		return task;
	}


	@Override
	public String getExpertSource(Long userId){
		List<User> userList = Lists.newArrayList();
		StringBuffer sql = new StringBuffer();
		sql.append("select A.expertSource,B.realName from risk_expertuser A,risk_se_user B where A.oid=B.oid and B.oid="+userId);
		List<Object> list = QueryHelper.findBySql(sql.toString(), null);
		if(list==null || list.size()==0){
			return "";
		}else{
			Map<String,Object> map = (HashMap<String,Object>)list.get(0);
			return map.get("expertSource").toString();
		}
	}

	/**
	 * 获取评估机构id
	 * @param activity
	 * @return
	 */
	@Override
	public Long getFengPingOrg(Activity activity){
		List<ActivityCooperDTO> orgList=activityCooperDao.findActivityCooperDtoByActivty(activity);
		if(orgList!=null){
			for(ActivityCooperDTO dto : orgList){
				if(Objects.equals(dto.getServiceOrgType(),DictConst.SERVICEORGTYPE_FXPGJG)){
					return Long.parseLong(dto.getOid());
				}
			}
		}
		return null;
	}

	@Override
	public Org getOrg(Activity activity){
		List<ActivityCooperDTO> orgList=activityCooperDao.findActivityCooperDtoByActivty(activity);
		if(orgList!=null){
			for(ActivityCooperDTO dto : orgList){
				if(Objects.equals(dto.getServiceOrgType(),DictConst.SERVICEORGTYPE_FXPGJG)){
					Org org=new Org();
					org.setOid(Long.parseLong(dto.getOid()));
					org.setName(dto.getName());
					org.setOrgType(dto.getServiceOrgType());
					return org;
				}
			}
		}
		return null;
	}

}
