package com.bcxin.survey.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

public class MultipleAuthenticationEntryPoint implements
		AuthenticationEntryPoint {

	private List<SecurityRedirect> securityRedirect = new ArrayList<SecurityRedirect>();

	private String defaultRedirect = "/manage/index";

	@Override
	public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException)
			throws IOException, ServletException {
		for (SecurityRedirect sr : securityRedirect) {
			String uri = request.getRequestURI();
			if (sr.match(uri)) {
				response.sendRedirect(request.getContextPath() + sr.direct());
				return;
			}
		}
	}

	public List<SecurityRedirect> getSecurityRedirect() {
		return securityRedirect;
	}

	public void setSecurityRedirect(List<SecurityRedirect> securityRedirect) {
		this.securityRedirect = securityRedirect;
	}

	public String getDefaultRedirect() {
		return defaultRedirect;
	}

	public void setDefaultRedirect(String defaultRedirect) {
		this.defaultRedirect = defaultRedirect;
	}

}
