package com.bcxin.survey.enums.report;

import java.util.ArrayList;
import java.util.List;

public enum TaskType {

	FILEUPLOAD {
		public String getValue() {
			return "1";
		}

		public String getName() {
			return "材料上传";
		}
	}, // 客户

	SURVEY {
		public String getValue() {
			return "2";
		}

		public String getName() {
			return "现场勘查";
		}
	}, // 勘查人员

	FILEVERIFY {
		public String getValue() {
			return "3";
		}

		public String getName() {
			return "材料审核";
		}
	}, // 审核人员

	FIRSTDRAFT {
		public String getValue() {
			return "4";
		}

		public String getName() {
			return "撰写初稿";
		}
	}, // 攥写人员

	FIRSTAUDIT {
		public String getValue() {
			return "5";
		}

		public String getName() {
			return "报告一审";
		}
	}, // 一审人员

	SECONDAUDIT {
		public String getValue() {
			return "6";
		}

		public String getName() {
			return "报告二审";
		}
	}, // 顾问

	REVIEW {
		public String getValue() {
			return "7";
		}

		public String getName() {
			return "报告复核";
		}
	}, // 复核专员

	EXPORT {
		public String getValue() {
			return "8";
		}

		public String getName() {
			return "报告导出";
		}
	}, // 行政人员

	VIDEO {
		public String getValue() {
			return "15";
		}

		public String getName() {
			return "视频任务";
		}
	}; // 客户

	public abstract String getValue();

	public abstract String getName();

	public static TaskType convert_value(String value) {
		if ("1".equals(value)) {
			return TaskType.FILEUPLOAD;
		} else if ("2".equals(value)) {
			return TaskType.SURVEY;
		} else if ("3".equals(value)) {
			return TaskType.FILEVERIFY;
		} else if ("4".equals(value)) {
			return TaskType.FIRSTDRAFT;
		} else if ("5".equals(value)) {
			return TaskType.FIRSTAUDIT;
		} else if ("6".equals(value)) {
			return TaskType.SECONDAUDIT;
		} else if ("7".equals(value)) {
			return TaskType.REVIEW;
		} else if ("8".equals(value)) {
			return TaskType.EXPORT;
		} else if ("15".equals(value)) {
			return TaskType.VIDEO;
		}
		return null;
	}


	public static TaskType convertName(String name) {
		if ("FILEUPLOAD".equals(name)) {
			return TaskType.FILEUPLOAD;
		} else if ("SURVEY".equals(name)) {
			return TaskType.SURVEY;
		} else if ("FILEVERIFY".equals(name)) {
			return TaskType.FILEVERIFY;
		} else if ("FIRSTDRAFT".equals(name)) {
			return TaskType.FIRSTDRAFT;
		} else if ("FIRSTAUDIT".equals(name)) {
			return TaskType.FIRSTAUDIT;
		} else if ("SECONDAUDIT".equals(name)) {
			return TaskType.SECONDAUDIT;
		} else if ("REVIEW".equals(name)) {
			return TaskType.REVIEW;
		} else if ("EXPORT".equals(name)) {
			return TaskType.EXPORT;
		} else if ("VIDEO".equals(name)) {
			return TaskType.VIDEO;
		}
		return null;
	}
	
	public static List<TaskType> assginList() {
		List<TaskType> list = new ArrayList<TaskType>();
		list.add(TaskType.FILEUPLOAD);
		list.add(TaskType.SURVEY);
		list.add(TaskType.FILEVERIFY);
		list.add(TaskType.FIRSTDRAFT);
		list.add(TaskType.FIRSTAUDIT);
		list.add(TaskType.SECONDAUDIT);
		list.add(TaskType.REVIEW);
		list.add(TaskType.EXPORT);
		return list;
	}
}
